/*
 * Decompiled with CFR 0.152.
 */
package swim.vm;

import java.util.Collection;
import org.graalvm.polyglot.Value;
import org.graalvm.polyglot.proxy.ProxyObject;
import swim.dynamic.Bridge;
import swim.dynamic.HostField;
import swim.dynamic.HostMember;
import swim.dynamic.HostMethod;
import swim.dynamic.HostObjectType;
import swim.vm.VmBridge;
import swim.vm.VmHostProxy;
import swim.vm.VmProxyArray;

public class VmHostObject<T>
extends VmHostProxy<T>
implements ProxyObject {
    final VmBridge bridge;
    final HostObjectType<? super T> type;
    final T self;

    public VmHostObject(VmBridge bridge, HostObjectType<? super T> type, T self) {
        this.bridge = bridge;
        this.type = type;
        this.self = self;
    }

    @Override
    public final T unwrap() {
        return this.self;
    }

    public boolean hasMember(String key) {
        HostMember member = this.type.getMember((Bridge)this.bridge, this.self, key);
        return member != null;
    }

    public Object getMember(String key) {
        HostMember member = this.type.getMember((Bridge)this.bridge, this.self, key);
        if (member instanceof HostField) {
            Object hostValue = ((HostField)member).get((Bridge)this.bridge, this.self);
            return this.bridge.hostToGuest(hostValue);
        }
        if (member instanceof HostMethod) {
            return this.bridge.hostMethodToGuestMethod((HostMethod)member, this.self);
        }
        return null;
    }

    public void putMember(String key, Value guestValue) {
        HostMember member = this.type.getMember((Bridge)this.bridge, this.self, key);
        if (!(member instanceof HostField)) {
            throw new UnsupportedOperationException();
        }
        Object hostValue = this.bridge.guestToHost(guestValue);
        ((HostField)member).set((Bridge)this.bridge, this.self, hostValue);
    }

    public boolean removeMember(String key) {
        HostMember member = this.type.getMember((Bridge)this.bridge, this.self, key);
        if (member instanceof HostField) {
            return ((HostField)member).remove((Bridge)this.bridge, this.self);
        }
        throw new UnsupportedOperationException();
    }

    public Object getMemberKeys() {
        Collection members = this.type.members((Bridge)this.bridge, this.self);
        Object[] memberKeys = new String[members.size()];
        int i = 0;
        for (HostMember member : members) {
            memberKeys[i] = member.key();
            ++i;
        }
        return new VmProxyArray(memberKeys);
    }
}

