/*
 * Decompiled with CFR 0.152.
 */
package swim.web;

import swim.collections.FingerTrieSeq;
import swim.http.HttpHeader;
import swim.http.HttpMethod;
import swim.http.HttpPayload;
import swim.http.HttpRequest;
import swim.http.HttpResponse;
import swim.http.HttpVersion;
import swim.io.http.HttpResponder;
import swim.io.http.StaticHttpResponder;
import swim.io.warp.WarpSettings;
import swim.io.warp.WarpSocket;
import swim.io.warp.WarpSocketContext;
import swim.io.warp.WarpWebSocket;
import swim.io.ws.WebSocket;
import swim.io.ws.WsSettings;
import swim.io.ws.WsUpgradeResponder;
import swim.uri.Uri;
import swim.uri.UriPath;
import swim.uri.UriQuery;
import swim.web.WebResponse;
import swim.web.WebServerAccepted;
import swim.web.WebServerRejected;
import swim.ws.WsResponse;

public abstract class WebRequest {
    public abstract HttpRequest<?> httpRequest();

    public HttpMethod httpMethod() {
        return this.httpRequest().method();
    }

    public Uri httpUri() {
        return this.httpRequest().uri();
    }

    public UriPath httpUriPath() {
        return this.httpUri().path();
    }

    public UriQuery httpUriQuery() {
        return this.httpUri().query();
    }

    public HttpVersion httpVersion() {
        return this.httpRequest().version();
    }

    public FingerTrieSeq<HttpHeader> httpHeaders() {
        return this.httpRequest().headers();
    }

    public HttpHeader getHttpHeader(String name) {
        return this.httpRequest().getHeader(name);
    }

    public <H extends HttpHeader> H getHttpHeader(Class<H> headerClass) {
        return (H)this.httpRequest().getHeader(headerClass);
    }

    public HttpPayload<?> httpPayload() {
        return this.httpRequest().payload();
    }

    public abstract UriPath routePath();

    public abstract WebRequest routePath(UriPath var1);

    public WebResponse accept(HttpResponder<?> responder) {
        return new WebServerAccepted(responder);
    }

    public WebResponse respond(HttpResponse<?> response) {
        return this.accept((HttpResponder<?>)new StaticHttpResponder(response));
    }

    public WebResponse upgrade(WebSocket<?, ?> webSocket, WsResponse wsResponse, WsSettings wsSettings) {
        return this.accept((HttpResponder<?>)new WsUpgradeResponder(webSocket, wsResponse, wsSettings));
    }

    public WebResponse upgrade(WarpSocket warpSocket, WsResponse wsResponse, WarpSettings warpSettings) {
        WarpWebSocket webSocket = new WarpWebSocket(warpSocket, warpSettings);
        warpSocket.setWarpSocketContext((WarpSocketContext)webSocket);
        return this.accept((HttpResponder<?>)new WsUpgradeResponder((WebSocket)webSocket, wsResponse, warpSettings.wsSettings()));
    }

    public WebResponse reject(HttpResponder<?> responder) {
        return new WebServerRejected(responder);
    }

    public WebResponse reject() {
        return WebServerRejected.notFound();
    }
}

