/*
 * Decompiled with CFR 0.152.
 */
package swim.web.route;

import swim.web.WebRequest;
import swim.web.WebResponse;
import swim.web.WebRoute;

public final class AlternativeRoute
implements WebRoute {
    final WebRoute[] routes;

    public AlternativeRoute(WebRoute ... routes) {
        this.routes = routes;
    }

    @Override
    public WebResponse routeRequest(WebRequest request) {
        for (WebRoute route : this.routes) {
            WebResponse response = route.routeRequest(request);
            if (!response.isAccepted()) continue;
            return response;
        }
        return request.reject();
    }

    @Override
    public WebRoute orElse(WebRoute alternative) {
        WebRoute[] oldRoutes = this.routes;
        int n = oldRoutes.length;
        WebRoute[] newRoutes = new WebRoute[n + 1];
        System.arraycopy(oldRoutes, 0, newRoutes, 0, n);
        newRoutes[n] = alternative;
        return new AlternativeRoute(newRoutes);
    }
}

