/*
 * Decompiled with CFR 0.152.
 */
package swim.web.route;

import java.io.IOException;
import java.util.Collection;
import swim.http.HttpBody;
import swim.http.HttpPayload;
import swim.http.HttpResponse;
import swim.http.HttpStatus;
import swim.uri.UriPath;
import swim.web.WebRequest;
import swim.web.WebResponse;
import swim.web.WebRoute;

public final class DirectoryRoute
implements WebRoute {
    final UriPath directory;
    final String indexFile;

    public DirectoryRoute(UriPath directory, String indexFile) {
        this.directory = directory;
        this.indexFile = indexFile;
    }

    @Override
    public WebResponse routeRequest(WebRequest request) {
        UriPath path = request.routePath();
        if (path.foot().isAbsolute()) {
            path = path.appended(this.indexFile);
        }
        if (path.isAbsolute()) {
            path = path.tail();
        }
        if ((path = this.directory.appended((Collection)path).removeDotSegments()).isRelativeTo(this.directory)) {
            try {
                HttpBody body = HttpBody.fromFile((String)path.toString());
                HttpResponse response = HttpResponse.create((HttpStatus)HttpStatus.OK).content((HttpPayload)body);
                return request.respond(response);
            }
            catch (IOException error) {
                return request.reject();
            }
        }
        return request.reject();
    }
}

