/*
 * Decompiled with CFR 0.152.
 */
package swim.xml;

import swim.codec.Diagnostic;
import swim.codec.Input;
import swim.codec.Output;
import swim.codec.Parser;
import swim.xml.Xml;
import swim.xml.XmlParser;

final class NameParser
extends Parser<String> {
    final XmlParser<?, ?> xml;
    final Output<String> output;
    final int step;

    NameParser(XmlParser<?, ?> xml, Output<String> output, int step) {
        this.xml = xml;
        this.output = output;
        this.step = step;
    }

    public Parser<String> feed(Input input) {
        return NameParser.parse(input, this.xml, this.output, this.step);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static Parser<String> parse(Input input, XmlParser<?, ?> xml, Output<String> output, int step) {
        int c = 0;
        if (step == 1) {
            if (input.isCont()) {
                c = input.head();
                if (!Xml.isNameStartChar(c)) return NameParser.error((Diagnostic)Diagnostic.expected((String)"name", (Input)input));
                if (output == null) {
                    output = xml.nameOutput();
                }
                input = input.step();
                output = output.write(c);
                step = 2;
            } else if (input.isDone()) {
                return NameParser.error((Diagnostic)Diagnostic.expected((String)"name", (Input)input));
            }
        }
        if (step == 2) {
            while (input.isCont() && Xml.isNameChar(c = input.head())) {
                input = input.step();
                output = output.write(c);
            }
            if (!input.isEmpty()) {
                return NameParser.done((Object)xml.name((String)output.bind()));
            }
        }
        if (!input.isError()) return new NameParser(xml, (Output<String>)output, step);
        return NameParser.error((Throwable)input.trap());
    }

    static Parser<String> parse(Input input, XmlParser<?, ?> xml, Output<String> output) {
        return NameParser.parse(input, xml, output, 1);
    }

    static Parser<String> parse(Input input, XmlParser<?, ?> xml) {
        return NameParser.parse(input, xml, null, 1);
    }
}

