/*
 * Decompiled with CFR 0.152.
 */
package swim.xml;

import swim.codec.Diagnostic;
import swim.codec.Input;
import swim.codec.Parser;
import swim.util.Builder;
import swim.xml.Xml;
import swim.xml.XmlParser;

final class TagEndParser<I, V>
extends Parser<V> {
    final XmlParser<I, V> xml;
    final String tag;
    final Builder<I, V> builder;
    final int step;

    TagEndParser(XmlParser<I, V> xml, String tag, Builder<I, V> builder, int step) {
        this.xml = xml;
        this.tag = tag;
        this.builder = builder;
        this.step = step;
    }

    public Parser<V> feed(Input input) {
        return TagEndParser.parse(input, this.xml, this.tag, this.builder, this.step);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static <I, V> Parser<V> parse(Input input, XmlParser<I, V> xml, String tag, Builder<I, V> builder, int step) {
        int c = 0;
        if (step == 1) {
            if (input.isCont()) {
                c = input.head();
                if (c != 60) return TagEndParser.error((Diagnostic)Diagnostic.expected((int)60, (Input)input));
                input = input.step();
                step = 2;
            } else if (input.isDone()) {
                return TagEndParser.error((Diagnostic)Diagnostic.expected((int)60, (Input)input));
            }
        }
        if (step == 2) {
            if (input.isCont()) {
                c = input.head();
                if (c != 47) return TagEndParser.error((Diagnostic)Diagnostic.expected((int)47, (Input)input));
                input = input.step();
                step = 3;
            } else if (input.isDone()) {
                return TagEndParser.error((Diagnostic)Diagnostic.expected((int)47, (Input)input));
            }
        }
        while (step >= 3 && step - 3 < tag.length()) {
            if (input.isCont()) {
                if (input.head() != tag.codePointAt(step - 3)) return TagEndParser.error((Diagnostic)Diagnostic.expected((String)("</" + tag + ">"), (Input)input));
                input = input.step();
                step = 3 + tag.offsetByCodePoints(step - 3, 1);
                continue;
            }
            if (!input.isDone()) break;
            return TagEndParser.error((Diagnostic)Diagnostic.expected((String)("</" + tag + ">"), (Input)input));
        }
        if (step == 3 + tag.length()) {
            while (input.isCont() && Xml.isWhitespace(c = input.head())) {
                input = input.step();
            }
            if (input.isCont()) {
                if (c != 62) return TagEndParser.error((Diagnostic)Diagnostic.expected((int)62, (Input)input));
                input = input.step();
                return TagEndParser.done((Object)builder.bind());
            }
            if (input.isDone()) {
                return TagEndParser.error((Diagnostic)Diagnostic.expected((int)62, (Input)input));
            }
        }
        if (!input.isError()) return new TagEndParser<I, V>(xml, tag, builder, step);
        return TagEndParser.error((Throwable)input.trap());
    }

    static <I, V> Parser<V> parse(Input input, XmlParser<I, V> xml, String tag, Builder<I, V> builder) {
        return TagEndParser.parse(input, xml, tag, builder, 1);
    }

    static <I, V> Parser<V> parseRest(Input input, XmlParser<I, V> xml, String tag, Builder<I, V> builder) {
        return TagEndParser.parse(input, xml, tag, builder, 3);
    }
}

