/*
 * Decompiled with CFR 0.152.
 */
package swim.xml;

import swim.codec.Parser;
import swim.structure.Item;
import swim.structure.Value;
import swim.xml.XmlModelParser;
import swim.xml.XmlParser;

public final class Xml {
    private static XmlParser<Item, Value> modelParser;

    private Xml() {
    }

    static boolean isSpace(int c) {
        return c == 32 || c == 9;
    }

    static boolean isNewline(int c) {
        return c == 10 || c == 13;
    }

    static boolean isWhitespace(int c) {
        return Xml.isSpace(c) || Xml.isNewline(c);
    }

    static boolean isChar(int c) {
        return c >= 1 && c <= 55295 || c >= 57344 && c <= 65533 || c >= 65536 && c <= 0x10FFFF;
    }

    static boolean isRestrictedChar(int c) {
        return c >= 1 && c <= 8 || c >= 11 && c <= 12 || c >= 14 && c <= 31 || c >= 127 && c <= 132 || c >= 134 && c <= 159;
    }

    static boolean isNameStartChar(int c) {
        return c == 58 || c >= 65 && c <= 90 || c == 95 || c >= 97 && c <= 122 || c >= 192 && c <= 214 || c >= 216 && c <= 246 || c >= 248 && c <= 767 || c >= 880 && c <= 893 || c >= 895 && c <= 8191 || c >= 8204 && c <= 8205 || c >= 8304 && c <= 8591 || c >= 11264 && c <= 12271 || c >= 12289 && c <= 55295 || c >= 63744 && c <= 64975 || c >= 65008 && c <= 65533 || c >= 65536 && c <= 983039;
    }

    static boolean isNameChar(int c) {
        return c == 45 || c == 46 || c >= 48 && c <= 57 || c == 58 || c >= 65 && c <= 90 || c == 95 || c >= 97 && c <= 122 || c == 183 || c >= 192 && c <= 214 || c >= 216 && c <= 246 || c >= 248 && c <= 893 || c >= 895 && c <= 8191 || c >= 8204 && c <= 8205 || c >= 8255 && c <= 8256 || c >= 8304 && c <= 8591 || c >= 11264 && c <= 12271 || c >= 12289 && c <= 55295 || c >= 63744 && c <= 64975 || c >= 65008 && c <= 65533 || c >= 65536 && c <= 983039;
    }

    static boolean isPubidChar(int c) {
        return c == 10 || c == 13 || c == 32 || c == 33 || c == 35 || c == 36 || c == 37 || c == 39 || c == 40 || c == 41 || c == 42 || c == 43 || c == 44 || c == 45 || c == 46 || c == 47 || c >= 48 && c <= 57 || c == 58 || c == 59 || c == 61 || c == 63 || c == 64 || c >= 65 && c <= 90 || c == 95 || c >= 97 && c <= 122;
    }

    public static XmlParser<Item, Value> modelParser() {
        if (modelParser == null) {
            modelParser = new XmlModelParser();
        }
        return modelParser;
    }

    public static Value parse(String xml) {
        return Xml.modelParser().parseDocumentString(xml);
    }

    public static Value parseFragment(String xml) {
        return Xml.modelParser().parseFragmentString(xml);
    }

    public static Parser<Value> parser() {
        return Xml.modelParser().documentParser();
    }
}

