/*
 * Decompiled with CFR 0.152.
 */
package swim.xml;

import swim.codec.Output;
import swim.codec.OutputSettings;
import swim.xml.XmlParser;

final class PIOutput<I>
extends Output<I> {
    final XmlParser<I, ?> xml;
    final String target;
    final StringBuilder builder;
    OutputSettings settings;

    PIOutput(XmlParser<I, ?> xml, String target, StringBuilder builder, OutputSettings settings) {
        this.xml = xml;
        this.target = target;
        this.builder = builder;
        this.settings = settings;
    }

    PIOutput(XmlParser<I, ?> xml, String target) {
        this(xml, target, new StringBuilder(), OutputSettings.standard());
    }

    public boolean isCont() {
        return true;
    }

    public boolean isFull() {
        return false;
    }

    public boolean isDone() {
        return false;
    }

    public boolean isError() {
        return false;
    }

    public boolean isPart() {
        return false;
    }

    public Output<I> isPart(boolean isPart) {
        return this;
    }

    public Output<I> write(int codePoint) {
        this.builder.appendCodePoint(codePoint);
        return this;
    }

    public Output<I> write(String string) {
        this.builder.append(string);
        return this;
    }

    public Output<I> writeln(String string) {
        this.builder.append(string).append(this.settings.lineSeparator());
        return this;
    }

    public Output<I> writeln() {
        this.builder.append(this.settings.lineSeparator());
        return this;
    }

    public OutputSettings settings() {
        return this.settings;
    }

    public Output<I> settings(OutputSettings settings) {
        this.settings = settings;
        return this;
    }

    public I bind() {
        return this.xml.pi(this.target, this.builder.toString());
    }

    public Output<I> clone() {
        return new PIOutput<I>(this.xml, this.target, new StringBuilder(this.builder.toString()), this.settings);
    }

    public String toString() {
        return this.builder.toString();
    }
}

