/*
 * Decompiled with CFR 0.152.
 */
package swim.xml;

import swim.codec.Diagnostic;
import swim.codec.Input;
import swim.codec.Output;
import swim.codec.Parser;
import swim.codec.Unicode;
import swim.util.Builder;
import swim.xml.AttributeValueParser;
import swim.xml.CDataSectionParser;
import swim.xml.CommentOutput;
import swim.xml.CommentParser;
import swim.xml.DoctypeDeclParser;
import swim.xml.DocumentParser;
import swim.xml.NameParser;
import swim.xml.PIOutput;
import swim.xml.PIParser;
import swim.xml.ReferenceParser;
import swim.xml.TagContentParser;
import swim.xml.TagEndParser;
import swim.xml.TagStartParser;
import swim.xml.Xml;
import swim.xml.XmlDeclParser;

public abstract class XmlParser<I, V> {
    public abstract I item(V var1);

    public abstract String name(String var1);

    public abstract I attribute(String var1, V var2);

    public abstract V attributes();

    public abstract I xml(V var1);

    public abstract I doctype(String var1);

    public abstract I doctype(String var1, String var2);

    public abstract I doctype(String var1, String var2, String var3);

    public abstract I tag(String var1);

    public abstract I tag(String var1, V var2);

    public abstract I comment(String var1);

    public abstract I pi(String var1, String var2);

    public abstract Output<String> nameOutput();

    public abstract Output<V> textOutput();

    public Output<I> commentOutput() {
        return new CommentOutput(this);
    }

    public Output<I> piOutput(String target) {
        return new PIOutput(this, target);
    }

    public abstract Builder<I, V> attributesBuilder();

    public abstract Builder<I, V> tagBuilder(String var1);

    public abstract Builder<I, V> tagBuilder(String var1, V var2);

    public abstract Builder<I, V> documentBuilder();

    public abstract Builder<I, V> fragmentBuilder();

    public boolean expandEntityRef(Output<?> output, String name) {
        if ("amp".equals(name)) {
            output = output.write(38);
            return true;
        }
        if ("lt".equals(name)) {
            output = output.write(60);
            return true;
        }
        if ("gt".equals(name)) {
            output = output.write(62);
            return true;
        }
        if ("apos".equals(name)) {
            output = output.write(39);
            return true;
        }
        if ("quot".equals(name)) {
            output = output.write(34);
            return true;
        }
        return false;
    }

    public Parser<String> parseName(Input input) {
        return NameParser.parse(input, this);
    }

    public Parser<V> parseAttributeValue(Input input) {
        return AttributeValueParser.parse(input, this);
    }

    public Parser<String> parseEntityName(Input input) {
        return NameParser.parse(input, this);
    }

    public Parser<?> parseReference(Input input, Output<?> text) {
        return ReferenceParser.parse(input, this, text);
    }

    public Parser<V> parseDocument(Input input) {
        return DocumentParser.parse(input, this);
    }

    public Parser<V> parseFragment(Input input) {
        return DocumentParser.parse(input, this, this.fragmentBuilder());
    }

    public Parser<I> parseXmlDecl(Input input) {
        return XmlDeclParser.parse(input, this);
    }

    public Parser<I> parseXmlDeclRest(Input input) {
        return XmlDeclParser.parseRest(input, this);
    }

    public Parser<I> parseDoctypeDecl(Input input) {
        return DoctypeDeclParser.parse(input, this);
    }

    public Parser<I> parseDoctypeDeclRest(Input input) {
        return DoctypeDeclParser.parseRest(input, this);
    }

    public Parser<V> parseMarkupDecl(Input input) {
        return Parser.error((Diagnostic)Diagnostic.message((String)"unsupported markup decl", (Input)input));
    }

    public Parser<V> parseTagStart(Input input) {
        return TagStartParser.parse(input, this);
    }

    public Parser<V> parseTagStartRest(Input input) {
        return TagStartParser.parseRest(input, this);
    }

    public Parser<V> parseTagStartRest(Input input, Builder<I, V> builder) {
        return TagStartParser.parseRest(input, this, builder);
    }

    public Parser<V> parseTagContent(Input input, String tag, Builder<I, V> builder) {
        return TagContentParser.parse(input, this, tag, builder);
    }

    public Parser<V> parseTagEnd(Input input, String tag, Builder<I, V> builder) {
        return TagEndParser.parse(input, this, tag, builder);
    }

    public Parser<V> parseTagEndRest(Input input, String tag, Builder<I, V> builder) {
        return TagEndParser.parseRest(input, this, tag, builder);
    }

    public Parser<?> parseCDataSection(Input input, Output<?> text) {
        return CDataSectionParser.parse(input, this, text);
    }

    public Parser<?> parseCDataSectionRest(Input input, Output<?> text) {
        return CDataSectionParser.parseRest(input, this, text);
    }

    public Parser<I> parseComment(Input input) {
        return CommentParser.parse(input, this);
    }

    public Parser<I> parseCommentRest(Input input) {
        return CommentParser.parseRest(input, this);
    }

    public Parser<I> parsePI(Input input) {
        return PIParser.parse(input, this);
    }

    public Parser<I> parsePIRest(Input input) {
        return PIParser.parseRest(input, this);
    }

    public Parser<String> parsePITarget(Input input) {
        return NameParser.parse(input, this);
    }

    public Parser<I> parsePITargetRest(Input input, String target) {
        return PIParser.parseTargetRest(input, this, target);
    }

    public Parser<V> documentParser() {
        return new DocumentParser(this);
    }

    public V parseDocumentString(String string) {
        Input input = Unicode.stringInput((String)string);
        while (input.isCont() && Xml.isWhitespace(input.head())) {
            input = input.step();
        }
        Parser parser = this.parseDocument(input);
        if (parser.isDone()) {
            while (input.isCont() && Xml.isWhitespace(input.head())) {
                input = input.step();
            }
        }
        if (input.isCont() && !parser.isError()) {
            parser = Parser.error((Diagnostic)Diagnostic.unexpected((Input)input));
        } else if (input.isError()) {
            parser = Parser.error((Throwable)input.trap());
        }
        return (V)parser.bind();
    }

    public V parseFragmentString(String string) {
        Input input = Unicode.stringInput((String)string);
        while (input.isCont() && Xml.isWhitespace(input.head())) {
            input = input.step();
        }
        Parser parser = this.parseFragment(input);
        if (parser.isDone()) {
            while (input.isCont() && Xml.isWhitespace(input.head())) {
                input = input.step();
            }
        }
        if (input.isCont() && !parser.isError()) {
            parser = Parser.error((Diagnostic)Diagnostic.unexpected((Input)input));
        } else if (input.isError()) {
            parser = Parser.error((Throwable)input.trap());
        }
        return (V)parser.bind();
    }
}

