/*
 * Decompiled with CFR 0.152.
 */
package org.swisspush.apikana.jsonschema2pojo;

import com.fasterxml.jackson.databind.JsonNode;
import com.sun.codemodel.JClassContainer;
import com.sun.codemodel.JCodeModel;
import com.sun.codemodel.JType;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.jsonschema2pojo.GenerationConfig;
import org.jsonschema2pojo.Schema;
import org.jsonschema2pojo.rules.PrimitiveTypes;
import org.jsonschema2pojo.rules.Rule;
import org.jsonschema2pojo.rules.RuleFactory;
import org.jsonschema2pojo.util.TypeUtil;

public class ApikanaTypeRule
implements Rule<JClassContainer, JType> {
    private static final String DEFAULT_TYPE_NAME = "any";
    private final RuleFactory ruleFactory;

    protected ApikanaTypeRule(RuleFactory ruleFactory) {
        this.ruleFactory = ruleFactory;
    }

    public JType apply(String nodeName, JsonNode node, JsonNode parent, JClassContainer jClassContainer, Schema schema) {
        String typeName;
        String propertyTypeName = this.getTypeName(node);
        Object type = propertyTypeName.equals("object") || node.has("properties") && node.path("properties").size() > 0 ? (JType)this.ruleFactory.getObjectRule().apply(nodeName, node, parent, (Object)jClassContainer.getPackage(), schema) : (node.has("javaType") ? (PrimitiveTypes.isPrimitive((String)(typeName = node.path("javaType").asText()), (JCodeModel)jClassContainer.owner()) ? PrimitiveTypes.primitiveType((String)typeName, (JCodeModel)jClassContainer.owner()) : TypeUtil.resolveType((JClassContainer)jClassContainer, (String)typeName)) : (propertyTypeName.equals("string") ? jClassContainer.owner().ref(String.class) : (propertyTypeName.equals("number") ? this.getNumberType(jClassContainer.owner(), this.ruleFactory.getGenerationConfig()) : (propertyTypeName.equals("integer") ? this.getIntegerType(jClassContainer.owner(), node, this.ruleFactory.getGenerationConfig()) : (propertyTypeName.equals("boolean") ? this.unboxIfNecessary((JType)jClassContainer.owner().ref(Boolean.class), this.ruleFactory.getGenerationConfig()) : (propertyTypeName.equals("array") ? (JType)this.ruleFactory.getArrayRule().apply(nodeName, node, parent, (Object)jClassContainer.getPackage(), schema) : jClassContainer.owner().ref(Object.class)))))));
        if (!node.has("javaType") && node.has("format")) {
            type = (JType)this.ruleFactory.getFormatRule().apply(nodeName, node.get("format"), node, type, schema);
        } else if (!node.has("javaType") && propertyTypeName.equals("string") && node.has("media")) {
            type = (JType)this.ruleFactory.getMediaRule().apply(nodeName, node.get("media"), node, type, schema);
        }
        return type;
    }

    private String getTypeName(JsonNode node) {
        if (node.has("type")) {
            JsonNode typeNode = node.get("type");
            if (typeNode.isArray() && typeNode.size() > 0) {
                List typeValues = StreamSupport.stream(typeNode.spliterator(), false).map(JsonNode::asText).filter(n -> !"null".equals(n)).collect(Collectors.toList());
                if (typeValues.size() == 1) {
                    return (String)typeValues.get(0);
                }
            } else if (typeNode.isTextual()) {
                return typeNode.asText();
            }
        }
        return DEFAULT_TYPE_NAME;
    }

    private JType unboxIfNecessary(JType type, GenerationConfig config) {
        if (config.isUsePrimitives()) {
            return type.unboxify();
        }
        return type;
    }

    private JType getIntegerType(JCodeModel owner, JsonNode node, GenerationConfig config) {
        if (config.isUseBigIntegers()) {
            return this.unboxIfNecessary((JType)owner.ref(BigInteger.class), config);
        }
        if (config.isUseLongIntegers() || node.has("minimum") && node.get("minimum").isLong() || node.has("maximum") && node.get("maximum").isLong()) {
            return this.unboxIfNecessary((JType)owner.ref(Long.class), config);
        }
        return this.unboxIfNecessary((JType)owner.ref(Integer.class), config);
    }

    private JType getNumberType(JCodeModel owner, GenerationConfig config) {
        if (config.isUseBigDecimals()) {
            return this.unboxIfNecessary((JType)owner.ref(BigDecimal.class), config);
        }
        if (config.isUseDoubleNumbers()) {
            return this.unboxIfNecessary((JType)owner.ref(Double.class), config);
        }
        return this.unboxIfNecessary((JType)owner.ref(Float.class), config);
    }
}

