/*
 * Decompiled with CFR 0.152.
 */
package org.swisspush.gateleen.hook;

import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.swisspush.gateleen.hook.Route;
import org.swisspush.gateleen.hook.RouteRepository;
import org.swisspush.gateleen.hook.RouteRepositoryBase;

public class LocalRouteRepository
extends RouteRepositoryBase<Map<String, Route>>
implements RouteRepository {
    private Logger log = LoggerFactory.getLogger(LocalRouteRepository.class);
    private Map<String, Route> routes = new HashMap<String, Route>();

    @Override
    public void addRoute(String urlPattern, Route route) {
        this.log.debug("Creating route for url pattern " + urlPattern + " and route destination " + route.getHook().getDestination());
        this.cleanupRoute(this.routes.get(urlPattern));
        this.routes.put(urlPattern, route);
    }

    @Override
    public void removeRoute(String urlPattern) {
        this.log.debug("Removing route for url pattern " + urlPattern);
        String routeKey = this.findFirstMatchingKey(this.routes, urlPattern);
        if (routeKey != null) {
            this.cleanupRoute(this.getRoute(routeKey));
            this.routes.remove(routeKey);
        }
    }

    @Override
    public Route getRoute(String url) {
        String key = this.findFirstMatchingKey(this.routes, url);
        return key != null ? this.routes.get(key) : null;
    }

    @Override
    boolean containsKey(Map<String, Route> container, String key) {
        return container.containsKey(key);
    }

    @Override
    public Map<String, Route> getRoutes() {
        return new HashMap<String, Route>(this.routes);
    }
}

