/*
 * Decompiled with CFR 0.152.
 */
package org.swisspush.gateleen.cache.fetch;

import io.vertx.core.Future;
import io.vertx.core.MultiMap;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.HttpClient;
import io.vertx.core.http.HttpClientRequest;
import io.vertx.core.http.HttpMethod;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.swisspush.gateleen.cache.fetch.CacheDataFetcher;
import org.swisspush.gateleen.core.util.Result;
import org.swisspush.gateleen.core.util.StatusCode;

public class DefaultCacheDataFetcher
implements CacheDataFetcher {
    private Logger log = LoggerFactory.getLogger(DefaultCacheDataFetcher.class);
    private HttpClient httpClient;
    private static final String SELF_REQUEST_HEADER = "x-self-request";
    private static final String CACHE_CONTROL_HEADER = "Cache-Control";
    private static final String CONTENT_TYPE_HEADER = "Content-Type";
    private static final String CONTENT_TYPE_JSON = "application/json";

    public DefaultCacheDataFetcher(HttpClient httpClient) {
        this.httpClient = httpClient;
    }

    @Override
    public Future<Result<Buffer, StatusCode>> fetchData(String requestUri, MultiMap requestHeaders, long requestTimeoutMs) {
        Future future = Future.future();
        requestHeaders.remove(CACHE_CONTROL_HEADER);
        HttpClientRequest cReq = this.httpClient.request(HttpMethod.GET, requestUri, cRes -> {
            cRes.bodyHandler(data -> {
                if (StatusCode.OK.getStatusCode() == cRes.statusCode()) {
                    String contentType = cRes.getHeader(CONTENT_TYPE_HEADER);
                    if (contentType != null && !contentType.contains(CONTENT_TYPE_JSON)) {
                        this.log.warn("Content-Type {} is not supported", (Object)contentType);
                        future.complete((Object)Result.err((Object)StatusCode.UNSUPPORTED_MEDIA_TYPE));
                        return;
                    }
                    future.complete((Object)Result.ok((Object)data));
                } else {
                    StatusCode statusCode = StatusCode.fromCode((int)cRes.statusCode());
                    if (statusCode == null) {
                        this.log.error("Got unkown status code {} while fetching cache data. Using 500 Internal Server Error instead", (Object)cRes.statusCode());
                        statusCode = StatusCode.INTERNAL_SERVER_ERROR;
                    }
                    future.complete((Object)Result.err((Object)statusCode));
                }
            });
            cRes.exceptionHandler(event -> {
                this.log.warn("Got an error while fetching cache data", event);
                future.complete((Object)Result.err((Object)StatusCode.INTERNAL_SERVER_ERROR));
            });
        });
        cReq.setTimeout(requestTimeoutMs);
        cReq.headers().setAll(requestHeaders);
        cReq.headers().set("Accept", CONTENT_TYPE_JSON);
        cReq.headers().set(SELF_REQUEST_HEADER, "true");
        cReq.setChunked(true);
        cReq.end();
        return future;
    }
}

