/*
 * Decompiled with CFR 0.152.
 */
package org.swisspush.gateleen.cache.storage;

import io.vertx.core.Future;
import io.vertx.core.json.JsonArray;
import io.vertx.redis.RedisClient;
import java.util.List;
import org.slf4j.Logger;
import org.swisspush.gateleen.core.lua.LuaScriptState;
import org.swisspush.gateleen.core.lua.RedisCommand;

public class ClearCacheRedisCommand
implements RedisCommand {
    private final LuaScriptState luaScriptState;
    private final List<String> keys;
    private final List<String> arguments;
    private final Future<Long> future;
    private final RedisClient redisClient;
    private final Logger log;

    public ClearCacheRedisCommand(LuaScriptState luaScriptState, List<String> keys, List<String> arguments, RedisClient redisClient, Logger log, Future<Long> future) {
        this.luaScriptState = luaScriptState;
        this.keys = keys;
        this.arguments = arguments;
        this.redisClient = redisClient;
        this.log = log;
        this.future = future;
    }

    public void exec(int executionCounter) {
        this.redisClient.evalsha(this.luaScriptState.getSha(), this.keys, this.arguments, event -> {
            if (event.succeeded()) {
                Long clearedItemsCount = ((JsonArray)event.result()).getLong(0);
                this.future.complete((Object)clearedItemsCount);
            } else {
                String message = event.cause().getMessage();
                if (message != null && message.startsWith("NOSCRIPT")) {
                    this.log.warn("ClearCacheRedisCommand script couldn't be found, reload it");
                    this.log.warn("amount the script got loaded: " + executionCounter);
                    if (executionCounter > 10) {
                        this.future.fail("amount the script got loaded is higher than 10, we abort");
                    } else {
                        this.luaScriptState.loadLuaScript((RedisCommand)new ClearCacheRedisCommand(this.luaScriptState, this.keys, this.arguments, this.redisClient, this.log, this.future), executionCounter);
                    }
                } else {
                    this.future.fail("ClearCacheRedisCommand request failed with message: " + message);
                }
            }
        });
    }
}

