/*
 * Decompiled with CFR 0.152.
 */
package org.swisspush.gateleen.cache.storage;

import io.vertx.core.Promise;
import io.vertx.redis.client.Response;
import java.util.List;
import org.slf4j.Logger;
import org.swisspush.gateleen.core.lua.LuaScriptState;
import org.swisspush.gateleen.core.lua.RedisCommand;
import org.swisspush.gateleen.core.redis.RedisProvider;
import org.swisspush.gateleen.core.util.RedisUtils;

public class CacheRequestRedisCommand
implements RedisCommand {
    private final LuaScriptState luaScriptState;
    private final List<String> keys;
    private final List<String> arguments;
    private final Promise<Void> promise;
    private final RedisProvider redisProvider;
    private final Logger log;

    public CacheRequestRedisCommand(LuaScriptState luaScriptState, List<String> keys, List<String> arguments, RedisProvider redisProvider, Logger log, Promise<Void> promise) {
        this.luaScriptState = luaScriptState;
        this.keys = keys;
        this.arguments = arguments;
        this.redisProvider = redisProvider;
        this.log = log;
        this.promise = promise;
    }

    public void exec(int executionCounter) {
        List args = RedisUtils.toPayload((Object[])new Object[]{this.luaScriptState.getSha(), this.keys.size(), this.keys, this.arguments});
        this.redisProvider.redis().onSuccess(redisAPI -> redisAPI.evalsha(args, event -> {
            if (event.succeeded()) {
                String resultStr = ((Response)event.result()).toString();
                if ("OK".equals(resultStr)) {
                    this.promise.complete();
                } else {
                    this.promise.fail("Cache request did not return 'OK'");
                }
            } else {
                String message = event.cause().getMessage();
                if (message != null && message.startsWith("NOSCRIPT")) {
                    this.log.warn("CacheRequestRedisCommand script couldn't be found, reload it");
                    this.log.warn("amount the script got loaded: " + executionCounter);
                    if (executionCounter > 10) {
                        this.promise.fail("amount the script got loaded is higher than 10, we abort");
                    } else {
                        this.luaScriptState.loadLuaScript((RedisCommand)new CacheRequestRedisCommand(this.luaScriptState, this.keys, this.arguments, this.redisProvider, this.log, this.promise), executionCounter);
                    }
                } else {
                    this.promise.fail("CacheRequestRedisCommand request failed with message: " + message);
                }
            }
        })).onFailure(throwable -> this.promise.fail("Redis: CacheRequestRedisCommand request failed with message: " + throwable.getMessage()));
    }
}

