/*
 * Decompiled with CFR 0.152.
 */
package org.swisspush.gateleen.cache.storage;

import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Promise;
import io.vertx.core.Vertx;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.json.JsonArray;
import io.vertx.redis.client.Response;
import java.time.Duration;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.swisspush.gateleen.cache.storage.CacheLuaScripts;
import org.swisspush.gateleen.cache.storage.CacheRequestRedisCommand;
import org.swisspush.gateleen.cache.storage.CacheStorage;
import org.swisspush.gateleen.cache.storage.ClearCacheRedisCommand;
import org.swisspush.gateleen.core.lock.Lock;
import org.swisspush.gateleen.core.lua.LuaScript;
import org.swisspush.gateleen.core.lua.LuaScriptState;
import org.swisspush.gateleen.core.redis.RedisProvider;
import org.swisspush.gateleen.core.util.Address;
import org.swisspush.gateleen.core.util.LockUtil;

public class RedisCacheStorage
implements CacheStorage {
    private Logger log = LoggerFactory.getLogger(RedisCacheStorage.class);
    private final Lock lock;
    private final RedisProvider redisProvider;
    private LuaScriptState clearCacheLuaScriptState;
    private LuaScriptState cacheRequestLuaScriptState;
    public static final String CACHED_REQUESTS = "gateleen.cache-cached-requests";
    public static final String CACHE_PREFIX = "gateleen.cache:";
    public static final String STORAGE_CLEANUP_TASK_LOCK = "cacheStorageCleanupTask";

    public RedisCacheStorage(Vertx vertx, Lock lock, RedisProvider redisProvider, long storageCleanupIntervalMs) {
        this.lock = lock;
        this.redisProvider = redisProvider;
        this.clearCacheLuaScriptState = new LuaScriptState((LuaScript)CacheLuaScripts.CLEAR_CACHE, redisProvider, false);
        this.cacheRequestLuaScriptState = new LuaScriptState((LuaScript)CacheLuaScripts.CACHE_REQUEST, redisProvider, false);
        vertx.setPeriodic(storageCleanupIntervalMs, event -> {
            String token = this.token(STORAGE_CLEANUP_TASK_LOCK);
            LockUtil.acquireLock((Lock)this.lock, (String)STORAGE_CLEANUP_TASK_LOCK, (String)token, (long)this.lockExpiry(storageCleanupIntervalMs), (Logger)this.log).onComplete(lockEvent -> {
                if (lockEvent.succeeded()) {
                    if (((Boolean)lockEvent.result()).booleanValue()) {
                        this.cleanup().onComplete(cleanupResult -> {
                            if (cleanupResult.failed()) {
                                this.log.warn("storage cleanup has failed", cleanupResult.cause());
                                LockUtil.releaseLock((Lock)lock, (String)STORAGE_CLEANUP_TASK_LOCK, (String)token, (Logger)this.log);
                            } else {
                                this.log.debug("Successfully cleaned {} entries from storage", cleanupResult.result());
                            }
                        });
                    }
                } else {
                    this.log.error("Could not acquire lock '{}'. Message: {}", (Object)STORAGE_CLEANUP_TASK_LOCK, (Object)lockEvent.cause().getMessage());
                }
            });
        });
    }

    private String token(String appendix) {
        return Address.instanceAddress() + "_" + System.currentTimeMillis() + "_" + appendix;
    }

    private long lockExpiry(long taskInterval) {
        if (taskInterval <= 1L) {
            return 1L;
        }
        return taskInterval / 2L;
    }

    @Override
    public Future<Void> cacheRequest(String cacheIdentifier, Buffer cachedObject, Duration cacheExpiry) {
        Promise promise = Promise.promise();
        List<String> keys = Collections.singletonList(CACHED_REQUESTS);
        List<String> arguments = List.of(CACHE_PREFIX, cacheIdentifier, cachedObject.toString(), String.valueOf(cacheExpiry.toMillis()));
        CacheRequestRedisCommand cmd = new CacheRequestRedisCommand(this.cacheRequestLuaScriptState, keys, arguments, this.redisProvider, this.log, (Promise<Void>)promise);
        cmd.exec(0);
        return promise.future();
    }

    @Override
    public Future<Optional<Buffer>> cachedRequest(String cacheIdentifier) {
        Promise promise = Promise.promise();
        this.redisProvider.redis().onSuccess(redisAPI -> redisAPI.get(CACHE_PREFIX + cacheIdentifier, event -> {
            if (event.failed()) {
                String message = "Failed to get cached request '" + cacheIdentifier + "'. Cause: " + RedisCacheStorage.logCause(event);
                this.log.error(message);
                promise.fail(message);
            } else if (event.result() != null) {
                promise.complete(Optional.of(Buffer.buffer((byte[])((Response)event.result()).toBytes())));
            } else {
                promise.complete(Optional.empty());
            }
        })).onFailure(throwable -> {
            String message = "Redis: Failed to get cached request '" + cacheIdentifier + "'. Cause: " + throwable.getMessage();
            this.log.error(message);
            promise.fail(message);
        });
        return promise.future();
    }

    @Override
    public Future<Long> clearCache() {
        Promise promise = Promise.promise();
        List<String> keys = Collections.singletonList(CACHED_REQUESTS);
        List<String> arguments = List.of(CACHE_PREFIX, "true");
        ClearCacheRedisCommand cmd = new ClearCacheRedisCommand(this.clearCacheLuaScriptState, keys, arguments, this.redisProvider, this.log, (Promise<Long>)promise);
        cmd.exec(0);
        return promise.future();
    }

    @Override
    public Future<Long> cacheEntriesCount() {
        Promise promise = Promise.promise();
        this.redisProvider.redis().onSuccess(redisAPI -> redisAPI.scard(CACHED_REQUESTS, reply -> {
            if (reply.failed()) {
                String message = "Failed to get count of cached requests. Cause: " + RedisCacheStorage.logCause(reply);
                this.log.error(message);
                promise.fail(message);
            } else {
                promise.complete((Object)((Response)reply.result()).toLong());
            }
        })).onFailure(throwable -> {
            String message = "Redis: Failed to get count of cached requests. Cause: " + throwable.getMessage();
            this.log.error(message);
            promise.fail(message);
        });
        return promise.future();
    }

    @Override
    public Future<Set<String>> cacheEntries() {
        Promise promise = Promise.promise();
        this.redisProvider.redis().onSuccess(redisAPI -> redisAPI.smembers(CACHED_REQUESTS, reply -> {
            if (reply.failed()) {
                String message = "Failed to get cached requests. Cause: " + RedisCacheStorage.logCause(reply);
                this.log.error(message);
                promise.fail(message);
            } else {
                JsonArray array = new JsonArray();
                ((Response)reply.result()).stream().forEach(arg_0 -> ((JsonArray)array).add(arg_0));
                Set result = IntStream.range(0, array.size()).mapToObj(arg_0 -> ((JsonArray)array).getString(arg_0)).map(Object::toString).collect(Collectors.toSet());
                promise.complete(result);
            }
        })).onFailure(throwable -> {
            String message = "Redis: Failed to get cached requests. Cause: " + throwable.getMessage();
            this.log.error(message);
            promise.fail(message);
        });
        return promise.future();
    }

    private Future<Long> cleanup() {
        Promise promise = Promise.promise();
        List<String> keys = Collections.singletonList(CACHED_REQUESTS);
        List<String> arguments = List.of(CACHE_PREFIX, "false");
        ClearCacheRedisCommand cmd = new ClearCacheRedisCommand(this.clearCacheLuaScriptState, keys, arguments, this.redisProvider, this.log, (Promise<Long>)promise);
        cmd.exec(0);
        return promise.future();
    }

    private static String logCause(AsyncResult result) {
        if (result.cause() != null) {
            return result.cause().getMessage();
        }
        return null;
    }
}

