/*
 * Decompiled with CFR 0.152.
 */
package org.swisspush.gateleen.core.property;

import io.vertx.core.Handler;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.http.HttpServerRequest;
import io.vertx.core.json.JsonObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.swisspush.gateleen.core.refresh.Refreshable;
import org.swisspush.gateleen.core.util.StatusCode;

public class PropertyHandler {
    private Logger log = LoggerFactory.getLogger(PropertyHandler.class);
    private final Map<String, Object> props;
    private final List<Refreshable> refreshables;
    private final Map<String, Map<String, String>> propertyUrls;
    private final String serverUri;

    public PropertyHandler(String serverUri, Map<String, Object> props) {
        this.serverUri = serverUri;
        this.props = props;
        this.refreshables = new ArrayList<Refreshable>();
        this.propertyUrls = new HashMap<String, Map<String, String>>();
    }

    public void addRefreshable(Refreshable refreshable) {
        this.refreshables.add(refreshable);
    }

    public void addProperty(String url, String value, String propertyName) {
        this.log.info("register property handler for property '" + propertyName + "' on url '" + url + "' and value id '" + value + "'.");
        String adaptedUrl = this.serverUri + url;
        if (this.propertyUrls.containsKey(adaptedUrl)) {
            this.propertyUrls.get(adaptedUrl).put(value, propertyName);
        } else {
            HashMap<String, String> map = new HashMap<String, String>();
            map.put(value, propertyName);
            this.propertyUrls.put(adaptedUrl, map);
        }
    }

    public boolean handle(final HttpServerRequest request) {
        if (request.method().equals((Object)HttpMethod.PUT) && this.propertyUrls.containsKey(request.uri())) {
            request.bodyHandler((Handler)new Handler<Buffer>(){

                public void handle(Buffer buffer) {
                    Map idProperties = (Map)PropertyHandler.this.propertyUrls.get(request.uri());
                    JsonObject body = new JsonObject(buffer.toString());
                    boolean found = false;
                    for (String keyId : idProperties.keySet()) {
                        if (!body.containsKey(keyId)) continue;
                        PropertyHandler.this.props.put(idProperties.get(keyId), body.getValue(keyId));
                        PropertyHandler.this.refresh();
                        found = true;
                        break;
                    }
                    if (!found) {
                        PropertyHandler.this.log.warn("id for the request PUT " + request.uri() + " could not be found: " + body.toString());
                    }
                    request.response().setStatusCode(StatusCode.OK.getStatusCode());
                    request.response().setStatusMessage(StatusCode.OK.getStatusMessage());
                    request.response().end();
                }
            });
            return true;
        }
        return false;
    }

    private void refresh() {
        for (Refreshable refreshable : this.refreshables) {
            refreshable.refresh();
        }
    }
}

