/*
 * Decompiled with CFR 0.152.
 */
package org.swisspush.gateleen.core.configuration;

import com.fasterxml.jackson.databind.JsonNode;
import com.github.fge.jsonschema.exceptions.ProcessingException;
import com.github.fge.jsonschema.main.JsonSchema;
import com.github.fge.jsonschema.main.JsonSchemaFactory;
import com.github.fge.jsonschema.report.ProcessingMessage;
import com.github.fge.jsonschema.report.ProcessingReport;
import com.github.fge.jsonschema.util.JsonLoader;
import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.json.DecodeException;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.core.logging.Logger;
import io.vertx.core.logging.LoggerFactory;
import java.io.IOException;
import org.swisspush.gateleen.core.json.JsonUtil;
import org.swisspush.gateleen.core.util.StringUtils;
import org.swisspush.gateleen.core.validation.ValidationResult;
import org.swisspush.gateleen.core.validation.ValidationStatus;

class ConfigurationResourceValidator {
    private static final String SCHEMA_DECLARATION = "http://json-schema.org/draft-04/schema#";
    private static JsonSchemaFactory factory = JsonSchemaFactory.byDefault();
    private Logger log = LoggerFactory.getLogger(ConfigurationResourceValidator.class);
    private Vertx vertx;

    public ConfigurationResourceValidator(Vertx vertx) {
        this.vertx = vertx;
    }

    public void validateConfigurationResource(Buffer configurationResource, String resourceSchema, Handler<AsyncResult<ValidationResult>> resultHandler) {
        this.vertx.executeBlocking(future -> {
            block12: {
                JsonObject schemaObject;
                if (!JsonUtil.isValidJson(configurationResource)) {
                    String message = "Unable to parse json";
                    this.log.warn((Object)message);
                    future.complete((Object)new ValidationResult(ValidationStatus.VALIDATED_NEGATIV, message));
                    return;
                }
                if (StringUtils.isEmpty(resourceSchema)) {
                    this.log.info((Object)"validated positive since no schema was provided");
                    future.complete((Object)new ValidationResult(ValidationStatus.VALIDATED_POSITIV));
                    return;
                }
                try {
                    schemaObject = new JsonObject(resourceSchema);
                }
                catch (DecodeException ex) {
                    String message = "Unable to parse json schema";
                    this.log.warn((Object)message);
                    future.complete((Object)new ValidationResult(ValidationStatus.VALIDATED_NEGATIV, message));
                    return;
                }
                if (SCHEMA_DECLARATION.equals(schemaObject.getString("$schema"))) {
                    JsonSchema schema;
                    try {
                        schema = factory.getJsonSchema(JsonLoader.fromString((String)resourceSchema));
                    }
                    catch (ProcessingException | IOException e) {
                        String message = "Cannot load schema";
                        this.log.warn((Object)message, e);
                        future.complete((Object)new ValidationResult(ValidationStatus.VALIDATED_NEGATIV, message));
                        return;
                    }
                    try {
                        ProcessingReport report = schema.validateUnchecked(JsonLoader.fromString((String)configurationResource.toString()));
                        if (report.isSuccess()) {
                            this.log.info((Object)"validated positive");
                            future.complete((Object)new ValidationResult(ValidationStatus.VALIDATED_POSITIV));
                            break block12;
                        }
                        JsonArray validationDetails = this.extractMessagesAsJson(report);
                        for (ProcessingMessage message : report) {
                            this.log.warn((Object)message.getMessage());
                        }
                        future.complete((Object)new ValidationResult(ValidationStatus.VALIDATED_NEGATIV, "Validation failed", validationDetails));
                    }
                    catch (IOException e) {
                        String message = "Cannot read JSON";
                        this.log.warn((Object)message, new Object[]{e.getMessage()});
                        future.complete((Object)new ValidationResult(ValidationStatus.VALIDATED_NEGATIV, message));
                    }
                } else {
                    String message = "Invalid schema: Expected property '$schema' with content 'http://json-schema.org/draft-04/schema#'";
                    this.log.warn((Object)message);
                    future.complete((Object)new ValidationResult(ValidationStatus.VALIDATED_NEGATIV, message));
                }
            }
        }, resultHandler);
    }

    private JsonArray extractMessagesAsJson(ProcessingReport report) {
        JsonArray resultArray = new JsonArray();
        for (ProcessingMessage msg : report) {
            JsonNode node = msg.asJson();
            resultArray.add(new JsonObject(node.toString()));
        }
        return resultArray;
    }
}

