/*
 * Decompiled with CFR 0.152.
 */
package org.swisspush.gateleen.core.util;

import io.vertx.core.http.HttpServerRequest;
import org.swisspush.gateleen.core.util.HttpRequestHeader;
import org.swisspush.gateleen.core.util.StringUtils;

public class HttpServerRequestUtil {
    private HttpServerRequestUtil() {
    }

    public static boolean isRemoteAddressLoopbackAddress(HttpServerRequest request) {
        String host = request.remoteAddress().host();
        if (StringUtils.isEmpty(host)) {
            return false;
        }
        return host.startsWith("127") || host.equalsIgnoreCase("localhost");
    }

    public static void increaseRequestHops(HttpServerRequest request) {
        Integer hops = HttpRequestHeader.getInteger(request.headers(), HttpRequestHeader.X_HOPS, 0);
        hops = hops + 1;
        request.headers().set(HttpRequestHeader.X_HOPS.getName(), String.valueOf(hops));
    }

    public static boolean isRequestHopsLimitExceeded(HttpServerRequest request, Integer hopsLimit) {
        if (hopsLimit == null) {
            return false;
        }
        Integer hops = HttpRequestHeader.getInteger(request.headers(), HttpRequestHeader.X_HOPS, 0);
        return hops > hopsLimit;
    }
}

