/*
 * Decompiled with CFR 0.152.
 */
package org.swisspush.gateleen.core.lua;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import org.junit.After;
import org.junit.Assume;
import org.junit.Before;
import org.junit.BeforeClass;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.exceptions.JedisConnectionException;

public abstract class AbstractLuaScriptTest {
    protected Jedis jedis = null;

    @BeforeClass
    public static void checkRedisAvailable() {
        Jedis j = new Jedis("localhost", 6379, 5000);
        try {
            j.flushAll();
        }
        catch (JedisConnectionException e) {
            Assume.assumeNoException((String)"Ignoring this test because no running redis is available. This is the case during release", (Throwable)e);
        }
    }

    @Before
    public void connect() {
        this.jedis = new Jedis("localhost", 6379, 5000);
        this.jedis.flushAll();
    }

    @After
    public void disconnect() {
        this.jedis.flushAll();
        this.jedis.close();
    }

    protected String readScript(String scriptFileName) {
        return this.readScript(scriptFileName, false);
    }

    protected String readScript(String scriptFileName, boolean stripLogNotice) {
        StringBuilder sb;
        BufferedReader in = new BufferedReader(new InputStreamReader(this.getClass().getClassLoader().getResourceAsStream(scriptFileName)));
        try {
            String line;
            sb = new StringBuilder();
            while ((line = in.readLine()) != null) {
                if (stripLogNotice && line.contains("redis.LOG_NOTICE,")) continue;
                sb.append(line + "\n");
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            try {
                in.close();
            }
            catch (IOException iOException) {}
        }
        return sb.toString();
    }
}

