/*
 * Decompiled with CFR 0.152.
 */
package org.swisspush.gateleen.core.storage;

import io.vertx.core.Handler;
import io.vertx.core.MultiMap;
import io.vertx.core.buffer.Buffer;
import java.util.HashMap;
import java.util.Map;
import org.swisspush.gateleen.core.storage.ResourceStorage;
import org.swisspush.gateleen.core.util.StatusCode;

public class MockResourceStorage
implements ResourceStorage {
    private Map<String, String> localStorageValues = new HashMap<String, String>();

    public MockResourceStorage() {
    }

    public MockResourceStorage(Map<String, String> initalMockData) {
        this.localStorageValues.putAll(initalMockData);
    }

    public void putMockData(String key, String value) {
        this.localStorageValues.put(key, value);
    }

    public Map<String, String> getMockData() {
        return this.localStorageValues;
    }

    @Override
    public void get(String path, Handler<Buffer> bodyHandler) {
        String result = this.localStorageValues.get(path);
        if (result != null) {
            bodyHandler.handle((Object)Buffer.buffer((String)result));
        } else {
            bodyHandler.handle(null);
        }
    }

    @Override
    public void put(String uri, MultiMap headers, Buffer buffer, Handler<Integer> doneHandler) {
        this.localStorageValues.put(uri, buffer.toString());
        doneHandler.handle((Object)StatusCode.OK.getStatusCode());
    }

    @Override
    public void put(String uri, Buffer buffer, Handler<Integer> doneHandler) {
        this.localStorageValues.put(uri, buffer.toString());
        doneHandler.handle((Object)StatusCode.OK.getStatusCode());
    }

    @Override
    public void delete(String uri, Handler<Integer> doneHandler) {
        this.localStorageValues.remove(uri);
        doneHandler.handle((Object)StatusCode.OK.getStatusCode());
    }
}

