/*
 * Decompiled with CFR 0.152.
 */
package org.swisspush.gateleen.core.util;

import com.google.common.base.Charsets;
import com.google.common.base.Strings;
import com.google.common.hash.Hashing;

public final class HashCodeGenerator {
    private HashCodeGenerator() {
    }

    public static String createHashCode(String uri, String payload) {
        String concatenated = HashCodeGenerator.trimIfNotNull(uri) + HashCodeGenerator.trimIfNotNull(payload);
        if (concatenated == null) {
            return null;
        }
        return Hashing.murmur3_128().hashString((CharSequence)concatenated, Charsets.UTF_8).toString();
    }

    public static String createSHA256HashCode(String dataToHash) {
        if (dataToHash == null) {
            return null;
        }
        return Hashing.sha256().hashString((CharSequence)HashCodeGenerator.trimIfNotNull(dataToHash), Charsets.UTF_8).toString();
    }

    private static String trimIfNotNull(String stringToTrim) {
        if (!Strings.isNullOrEmpty((String)stringToTrim)) {
            return stringToTrim.trim();
        }
        return stringToTrim;
    }
}

