/*
 * Decompiled with CFR 0.152.
 */
package org.swisspush.gateleen.core.util;

import io.vertx.core.http.HttpServerRequest;
import org.swisspush.gateleen.core.http.RequestLoggerFactory;
import org.swisspush.gateleen.core.util.StatusCode;

public final class ResponseStatusCodeLogUtil {
    private static final String SELF_REQUEST_HEADER = "x-self-request";

    private ResponseStatusCodeLogUtil() {
    }

    public static void debug(HttpServerRequest request, StatusCode statusCode, Class<?> caller) {
        if (request != null && statusCode != null && caller != null && !request.headers().contains(SELF_REQUEST_HEADER)) {
            RequestLoggerFactory.getLogger(caller, request).debug("Responding " + request.method() + " request to " + request.uri() + " with status code " + (Object)((Object)statusCode));
        }
        request.headers().remove(SELF_REQUEST_HEADER);
    }

    public static void info(HttpServerRequest request, StatusCode statusCode, Class<?> caller) {
        if (request != null && statusCode != null && caller != null && !request.headers().contains(SELF_REQUEST_HEADER)) {
            RequestLoggerFactory.getLogger(caller, request).info("Responding " + request.method() + " request to " + request.uri() + " with status code " + (Object)((Object)statusCode));
        }
        request.headers().remove(SELF_REQUEST_HEADER);
    }

    public static boolean isRequestToExternalTarget(String target) {
        boolean isInternalRequest = false;
        if (target != null) {
            isInternalRequest = target.contains("localhost") || target.contains("127.0.0.1");
        }
        return !isInternalRequest;
    }
}

