/*
 * Decompiled with CFR 0.152.
 */
package org.swisspush.gateleen.core.http;

import io.vertx.core.MultiMap;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.swisspush.gateleen.core.http.HeaderFunction;

public class HeaderFunctions {
    private static final Logger LOG = LoggerFactory.getLogger(HeaderFunctions.class);
    private static final EvalScope NO_ERROR_SCOPE = new EvalScope(null);
    public static final HeaderFunction DO_NOTHING = headers -> NO_ERROR_SCOPE;
    private static final Pattern VARIABLE_PATTERN = Pattern.compile("[{](.+?)[}]");

    public static HeaderFunction parseFromJson(JsonArray config) throws IllegalArgumentException {
        LOG.debug("creating header function chain from " + config);
        Consumer<EvalScope> chain = null;
        for (int pos = 0; pos < config.size(); ++pos) {
            JsonObject rule = config.getJsonObject(pos);
            Consumer<EvalScope> c = HeaderFunctions.parseOneFromJason(config, rule);
            chain = chain == null ? c : chain.andThen(c);
        }
        return HeaderFunctions.wrapConsumerChain(chain);
    }

    @Deprecated
    public static HeaderFunction parseStaticHeadersFromJson(JsonObject staticHeaders) {
        Consumer<EvalScope> chain = null;
        for (Map.Entry entry : staticHeaders.getMap().entrySet()) {
            String headerName = (String)entry.getKey();
            Object value = entry.getValue();
            Consumer<EvalScope> c = value == null || value.toString().isEmpty() ? HeaderFunctions.remove(headerName) : HeaderFunctions.setAlways(headerName, value.toString());
            chain = chain == null ? c : chain.andThen(c);
        }
        return HeaderFunctions.wrapConsumerChain(chain);
    }

    private static HeaderFunction wrapConsumerChain(Consumer<EvalScope> chain) {
        if (chain == null) {
            return DO_NOTHING;
        }
        return headers -> {
            EvalScope scope = new EvalScope(headers);
            chain.accept(scope);
            return scope;
        };
    }

    private static Consumer<EvalScope> parseOneFromJason(JsonArray config, JsonObject rule) throws IllegalArgumentException {
        String headerName = rule.getString("header");
        String expression = rule.getString("value");
        String mode = rule.getString("mode");
        if (headerName == null) {
            throw new IllegalArgumentException("missing attribute \"header\" in " + rule + " (part of " + config + ")");
        }
        if (!rule.containsKey("value")) {
            throw new IllegalArgumentException("missing attribute \"value\" in " + rule + " (part of " + config + ")");
        }
        if (expression == null) {
            return HeaderFunctions.remove(headerName);
        }
        if (mode == null) {
            return HeaderFunctions.setAlways(headerName, expression);
        }
        if ("complete".equals(mode)) {
            return HeaderFunctions.setIfAbsent(headerName, expression);
        }
        if ("override".equals(mode)) {
            return HeaderFunctions.setIfPresent(headerName, expression);
        }
        throw new IllegalArgumentException("illegal value for \"mode\" in " + rule + " (part of " + config + "). Only \"complete\" or \"override\" allowed - or no \"mode\" at all");
    }

    public static Consumer<EvalScope> remove(String headerName) {
        return scope -> scope.headers.remove(headerName);
    }

    public static Consumer<EvalScope> setAlways(String headerName, String expression) {
        Function<EvalScope, String> exprEval = HeaderFunctions.newExpressionEvaluator(expression);
        return scope -> {
            String value = (String)exprEval.apply((EvalScope)scope);
            scope.headers.set(headerName, value);
        };
    }

    public static Consumer<EvalScope> setIfAbsent(String headerName, String expression) {
        Function<EvalScope, String> exprEval = HeaderFunctions.newExpressionEvaluator(expression);
        return scope -> {
            if (!scope.headers.contains(headerName)) {
                String value = (String)exprEval.apply((EvalScope)scope);
                scope.headers.set(headerName, value);
            }
        };
    }

    public static Consumer<EvalScope> setIfPresent(String headerName, String expression) {
        Function<EvalScope, String> exprEval = HeaderFunctions.newExpressionEvaluator(expression);
        return scope -> {
            if (scope.headers.contains(headerName)) {
                String value = (String)exprEval.apply((EvalScope)scope);
                scope.headers.set(headerName, value);
            }
        };
    }

    private static Function<EvalScope, String> newExpressionEvaluator(String expression) {
        if (expression.indexOf(123) < 0) {
            return scope -> expression;
        }
        Consumer<EvalScope> chain = scope -> {};
        Matcher matcher = VARIABLE_PATTERN.matcher(expression);
        int idx = 0;
        while (matcher.find()) {
            int from = matcher.start();
            int to = matcher.end();
            String fix = expression.substring(idx, from);
            chain = HeaderFunctions.andThenFix(chain, fix);
            String varName = matcher.group(1);
            chain = HeaderFunctions.andThenVar(chain, varName, expression);
            idx = to;
        }
        String fix = expression.substring(idx);
        Consumer<EvalScope> finalEvaluatorChain = chain = HeaderFunctions.andThenFix(chain, fix);
        return scope -> {
            LOG.debug("evaluating '{}' on headers '{}'", (Object)expression, (Object)scope.headers);
            ((EvalScope)scope).initBuffer();
            finalEvaluatorChain.accept((EvalScope)scope);
            String result = ((EvalScope)scope).sb.toString();
            LOG.debug("evaluating '{}' on headers '{}' results to '{}'", new Object[]{expression, scope.headers, result});
            return result;
        };
    }

    private static Consumer<EvalScope> andThenFix(Consumer<EvalScope> c, String fix) {
        if (fix.length() == 0) {
            return c;
        }
        return c.andThen(scope -> ((EvalScope)scope).sb.append(fix));
    }

    private static Consumer<EvalScope> andThenVar(Consumer<EvalScope> c, String varName, String expression) {
        return c.andThen(scope -> {
            String value = scope.headers.get(varName);
            if (value == null) {
                ((EvalScope)scope).sb.append('{').append(varName).append('}');
                ((EvalScope)scope).errorMessage = "unresolvable '{" + varName + "}' in exprssion '" + expression + "'";
            } else {
                ((EvalScope)scope).sb.append(value);
            }
        });
    }

    public static class EvalScope {
        public final MultiMap headers;
        private StringBuilder sb;
        private String errorMessage;

        EvalScope(MultiMap headers) {
            this.headers = headers;
        }

        private void initBuffer() {
            if (this.sb == null) {
                this.sb = new StringBuilder();
            } else {
                this.sb.setLength(0);
            }
        }

        public String getErrorMessage() {
            return this.errorMessage;
        }
    }
}

