/*
 * Decompiled with CFR 0.152.
 */
package org.swisspush.gateleen.core.http;

import io.netty.handler.codec.http.QueryStringDecoder;
import io.vertx.codegen.annotations.Nullable;
import io.vertx.core.Handler;
import io.vertx.core.MultiMap;
import io.vertx.core.Vertx;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.CaseInsensitiveHeaders;
import io.vertx.core.http.HttpClientRequest;
import io.vertx.core.http.HttpClientResponse;
import io.vertx.core.http.HttpConnection;
import io.vertx.core.http.HttpFrame;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.http.HttpServerFileUpload;
import io.vertx.core.http.HttpServerRequest;
import io.vertx.core.http.HttpServerResponse;
import io.vertx.core.http.HttpVersion;
import io.vertx.core.http.ServerWebSocket;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.core.net.NetSocket;
import io.vertx.core.net.SocketAddress;
import io.vertx.core.net.impl.SocketAddressImpl;
import io.vertx.ext.auth.User;
import io.vertx.ext.web.Cookie;
import io.vertx.ext.web.FileUpload;
import io.vertx.ext.web.Locale;
import io.vertx.ext.web.ParsedHeaderValues;
import io.vertx.ext.web.Route;
import io.vertx.ext.web.RoutingContext;
import io.vertx.ext.web.Session;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLSession;
import javax.security.cert.X509Certificate;
import org.swisspush.gateleen.core.http.BufferBridge;
import org.swisspush.gateleen.core.http.UriParser;

public class LocalHttpClientRequest
extends BufferBridge
implements HttpClientRequest {
    private MultiMap headers = new CaseInsensitiveHeaders();
    private MultiMap params;
    private HttpMethod method;
    private String uri;
    private String path;
    private String query;
    private HttpServerResponse response;
    private Handler<RoutingContext> routingContextHandler;
    private boolean bound = false;
    private static final SocketAddress address = new SocketAddressImpl(0, "localhost");
    private HttpServerRequest serverRequest = new HttpServerRequest(){

        public HttpVersion version() {
            return HttpVersion.HTTP_1_0;
        }

        public HttpMethod method() {
            return LocalHttpClientRequest.this.method;
        }

        public String rawMethod() {
            throw new UnsupportedOperationException();
        }

        public boolean isSSL() {
            return false;
        }

        public @Nullable String scheme() {
            throw new UnsupportedOperationException();
        }

        public String uri() {
            return LocalHttpClientRequest.this.uri;
        }

        public String path() {
            if (LocalHttpClientRequest.this.path == null) {
                LocalHttpClientRequest.this.path = UriParser.path(this.uri());
            }
            return LocalHttpClientRequest.this.path;
        }

        public String query() {
            if (LocalHttpClientRequest.this.query == null) {
                LocalHttpClientRequest.this.query = UriParser.query(this.uri());
            }
            return LocalHttpClientRequest.this.query;
        }

        public @Nullable String host() {
            throw new UnsupportedOperationException();
        }

        public MultiMap params() {
            if (LocalHttpClientRequest.this.params == null) {
                QueryStringDecoder queryStringDecoder = new QueryStringDecoder(this.uri());
                Map prms = queryStringDecoder.parameters();
                LocalHttpClientRequest.this.params = (MultiMap)new CaseInsensitiveHeaders();
                if (!prms.isEmpty()) {
                    for (Map.Entry entry : prms.entrySet()) {
                        LocalHttpClientRequest.this.params.add((String)entry.getKey(), (Iterable)entry.getValue());
                    }
                }
            }
            return LocalHttpClientRequest.this.params;
        }

        public String getParam(String paramName) {
            return this.params().get(paramName);
        }

        public MultiMap headers() {
            return LocalHttpClientRequest.this.headers;
        }

        public String getHeader(String headerName) {
            return this.headers().get(headerName);
        }

        public String getHeader(CharSequence headerName) {
            return this.headers().get(headerName);
        }

        public SocketAddress remoteAddress() {
            return address;
        }

        public SocketAddress localAddress() {
            return address;
        }

        public SSLSession sslSession() {
            return null;
        }

        public X509Certificate[] peerCertificateChain() throws SSLPeerUnverifiedException {
            return new X509Certificate[0];
        }

        public String absoluteURI() {
            return "local:" + LocalHttpClientRequest.this.uri;
        }

        public NetSocket netSocket() {
            return null;
        }

        public HttpServerRequest setExpectMultipart(boolean expect) {
            return null;
        }

        public boolean isExpectMultipart() {
            return false;
        }

        public HttpServerRequest uploadHandler(Handler<HttpServerFileUpload> uploadHandler) {
            throw new UnsupportedOperationException();
        }

        public MultiMap formAttributes() {
            throw new UnsupportedOperationException();
        }

        public String getFormAttribute(String attributeName) {
            throw new UnsupportedOperationException();
        }

        public ServerWebSocket upgrade() {
            throw new UnsupportedOperationException();
        }

        public boolean isEnded() {
            throw new UnsupportedOperationException();
        }

        public HttpServerRequest customFrameHandler(Handler<HttpFrame> handler) {
            throw new UnsupportedOperationException();
        }

        public HttpConnection connection() {
            throw new UnsupportedOperationException();
        }

        public HttpServerRequest endHandler(Handler<Void> handler) {
            LocalHttpClientRequest.this.setEndHandler(handler);
            return this;
        }

        public HttpServerRequest handler(Handler<Buffer> handler) {
            LocalHttpClientRequest.this.setDataHandler(handler);
            LocalHttpClientRequest.this.pump();
            return this;
        }

        public HttpServerRequest pause() {
            return this;
        }

        public HttpServerRequest resume() {
            return this;
        }

        public HttpServerResponse response() {
            return LocalHttpClientRequest.this.response;
        }

        public HttpServerRequest exceptionHandler(Handler<Throwable> handler) {
            return this;
        }
    };
    private RoutingContext routingContext = new RoutingContext(){

        public HttpServerRequest request() {
            return LocalHttpClientRequest.this.serverRequest;
        }

        public HttpServerResponse response() {
            return LocalHttpClientRequest.this.response;
        }

        public void next() {
            throw new UnsupportedOperationException();
        }

        public void fail(int statusCode) {
            throw new UnsupportedOperationException();
        }

        public void fail(Throwable throwable) {
            throw new UnsupportedOperationException();
        }

        public RoutingContext put(String key, Object obj) {
            throw new UnsupportedOperationException();
        }

        public <T> T get(String key) {
            throw new UnsupportedOperationException();
        }

        public <T> T remove(String key) {
            throw new UnsupportedOperationException();
        }

        public Map<String, Object> data() {
            throw new UnsupportedOperationException();
        }

        public Vertx vertx() {
            throw new UnsupportedOperationException();
        }

        public String mountPoint() {
            throw new UnsupportedOperationException();
        }

        public Route currentRoute() {
            throw new UnsupportedOperationException();
        }

        public String normalisedPath() {
            throw new UnsupportedOperationException();
        }

        public Cookie getCookie(String name) {
            throw new UnsupportedOperationException();
        }

        public RoutingContext addCookie(Cookie cookie) {
            throw new UnsupportedOperationException();
        }

        public Cookie removeCookie(String name) {
            throw new UnsupportedOperationException();
        }

        public int cookieCount() {
            throw new UnsupportedOperationException();
        }

        public Set<Cookie> cookies() {
            throw new UnsupportedOperationException();
        }

        public String getBodyAsString() {
            throw new UnsupportedOperationException();
        }

        public String getBodyAsString(String encoding) {
            throw new UnsupportedOperationException();
        }

        public JsonObject getBodyAsJson() {
            throw new UnsupportedOperationException();
        }

        public JsonArray getBodyAsJsonArray() {
            throw new UnsupportedOperationException();
        }

        public Buffer getBody() {
            throw new UnsupportedOperationException();
        }

        public Set<FileUpload> fileUploads() {
            throw new UnsupportedOperationException();
        }

        public Session session() {
            throw new UnsupportedOperationException();
        }

        public User user() {
            throw new UnsupportedOperationException();
        }

        public Throwable failure() {
            throw new UnsupportedOperationException();
        }

        public int statusCode() {
            throw new UnsupportedOperationException();
        }

        public String getAcceptableContentType() {
            throw new UnsupportedOperationException();
        }

        public ParsedHeaderValues parsedHeaders() {
            throw new UnsupportedOperationException();
        }

        public int addHeadersEndHandler(Handler<Void> handler) {
            throw new UnsupportedOperationException();
        }

        public boolean removeHeadersEndHandler(int handlerID) {
            throw new UnsupportedOperationException();
        }

        public int addBodyEndHandler(Handler<Void> handler) {
            throw new UnsupportedOperationException();
        }

        public boolean removeBodyEndHandler(int handlerID) {
            throw new UnsupportedOperationException();
        }

        public boolean failed() {
            throw new UnsupportedOperationException();
        }

        public void setBody(Buffer body) {
            throw new UnsupportedOperationException();
        }

        public void setSession(Session session) {
            throw new UnsupportedOperationException();
        }

        public void setUser(User user) {
            throw new UnsupportedOperationException();
        }

        public void clearUser() {
            throw new UnsupportedOperationException();
        }

        public void setAcceptableContentType(String contentType) {
            throw new UnsupportedOperationException();
        }

        public void reroute(String path) {
            throw new UnsupportedOperationException();
        }

        public void reroute(HttpMethod method, String path) {
            throw new UnsupportedOperationException();
        }

        public List<Locale> acceptableLocales() {
            throw new UnsupportedOperationException();
        }

        public Locale preferredLocale() {
            throw new UnsupportedOperationException();
        }

        public Map<String, String> pathParams() {
            throw new UnsupportedOperationException();
        }

        public @Nullable String pathParam(String name) {
            throw new UnsupportedOperationException();
        }

        public MultiMap queryParams() {
            throw new UnsupportedOperationException();
        }

        public @Nullable List<String> queryParam(String query) {
            throw new UnsupportedOperationException();
        }
    };

    public LocalHttpClientRequest(HttpMethod method, String uri, Vertx vertx, Handler<RoutingContext> routingContextHandler, HttpServerResponse response) {
        super(vertx);
        this.method = method;
        this.uri = uri;
        this.routingContextHandler = routingContextHandler;
        this.response = response;
    }

    public HttpClientRequest setChunked(boolean chunked) {
        return this;
    }

    public boolean isChunked() {
        return false;
    }

    public HttpMethod method() {
        return null;
    }

    public String getRawMethod() {
        return null;
    }

    public HttpClientRequest setRawMethod(String method) {
        return this;
    }

    public String absoluteURI() {
        return null;
    }

    public String uri() {
        return null;
    }

    public String path() {
        return null;
    }

    public String query() {
        return null;
    }

    public HttpClientRequest setHost(String host) {
        return this;
    }

    public String getHost() {
        return null;
    }

    public MultiMap headers() {
        return this.headers;
    }

    public HttpClientRequest putHeader(String name, String value) {
        this.headers().set(name, value);
        return this;
    }

    public HttpClientRequest putHeader(CharSequence name, CharSequence value) {
        this.headers().set(name, value);
        return this;
    }

    public HttpClientRequest putHeader(String name, Iterable<String> values) {
        for (String value : values) {
            this.headers().add(name, value);
        }
        return this;
    }

    public HttpClientRequest putHeader(CharSequence name, Iterable<CharSequence> values) {
        for (CharSequence value : values) {
            this.headers().add(name, value);
        }
        return this;
    }

    public HttpClientRequest write(Buffer chunk) {
        this.ensureBound();
        this.doWrite(chunk);
        return this;
    }

    private void ensureBound() {
        if (!this.bound) {
            this.bound = true;
            this.routingContextHandler.handle((Object)this.routingContext);
        }
    }

    public HttpClientRequest write(String chunk) {
        this.write(Buffer.buffer((String)chunk));
        return this;
    }

    public HttpClientRequest write(String chunk, String enc) {
        this.write(Buffer.buffer((String)chunk, (String)enc));
        return this;
    }

    public HttpClientRequest continueHandler(Handler<Void> handler) {
        throw new UnsupportedOperationException();
    }

    public HttpClientRequest sendHead() {
        return this;
    }

    public HttpClientRequest sendHead(Handler<HttpVersion> completionHandler) {
        return this;
    }

    public void end(String chunk) {
        this.write(chunk);
        this.end();
    }

    public void end(String chunk, String enc) {
        this.write(chunk, enc);
        this.end();
    }

    public void end(Buffer chunk) {
        this.write(chunk);
        this.end();
    }

    public void end() {
        this.ensureBound();
        this.doEnd();
    }

    public HttpClientRequest setTimeout(long timeoutMs) {
        return this;
    }

    public HttpClientRequest pushHandler(Handler<HttpClientRequest> handler) {
        return this;
    }

    public boolean reset() {
        return false;
    }

    public boolean reset(long code) {
        return false;
    }

    public HttpConnection connection() {
        return null;
    }

    public HttpClientRequest connectionHandler(@Nullable Handler<HttpConnection> handler) {
        return this;
    }

    public HttpClientRequest writeCustomFrame(int type, int flags, Buffer payload) {
        return this;
    }

    public HttpClientRequest setWriteQueueMaxSize(int maxSize) {
        return this;
    }

    public boolean writeQueueFull() {
        return false;
    }

    public HttpClientRequest drainHandler(Handler<Void> handler) {
        return this;
    }

    public HttpClientRequest handler(Handler<HttpClientResponse> handler) {
        throw new UnsupportedOperationException();
    }

    public HttpClientRequest pause() {
        throw new UnsupportedOperationException();
    }

    public HttpClientRequest resume() {
        throw new UnsupportedOperationException();
    }

    public HttpClientRequest endHandler(Handler<Void> endHandler) {
        throw new UnsupportedOperationException();
    }

    public HttpClientRequest setFollowRedirects(boolean followRedirects) {
        throw new UnsupportedOperationException();
    }

    public HttpClientRequest exceptionHandler(Handler<Throwable> handler) {
        this.setExceptionHandler(handler);
        return this;
    }

    public void setMethod(HttpMethod method) {
        this.method = method;
    }

    public void setUri(String uri) {
        this.uri = uri;
    }
}

