/*
 * Decompiled with CFR 0.152.
 */
package org.swisspush.gateleen.core.http;

import io.vertx.codegen.annotations.Nullable;
import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;
import io.vertx.core.MultiMap;
import io.vertx.core.Vertx;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.CaseInsensitiveHeaders;
import io.vertx.core.http.HttpClientRequest;
import io.vertx.core.http.HttpClientResponse;
import io.vertx.core.http.HttpFrame;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.http.HttpServerResponse;
import io.vertx.core.http.HttpVersion;
import io.vertx.core.net.NetSocket;
import java.util.List;
import org.swisspush.gateleen.core.http.BufferBridge;
import org.swisspush.gateleen.core.util.StatusCode;

public class LocalHttpServerResponse
extends BufferBridge
implements HttpServerResponse {
    private int statusCode;
    private String statusMessage;
    private static final String EMPTY = "";
    private Handler<HttpClientResponse> responseHandler;
    private MultiMap headers = new CaseInsensitiveHeaders();
    private boolean bound = false;
    private HttpClientResponse clientResponse = new HttpClientResponse(){

        public int statusCode() {
            return LocalHttpServerResponse.this.statusCode;
        }

        public String statusMessage() {
            if (LocalHttpServerResponse.this.statusMessage == null) {
                StatusCode code = StatusCode.fromCode(this.statusCode());
                if (code != null) {
                    LocalHttpServerResponse.this.statusMessage = code.getStatusMessage();
                } else {
                    LocalHttpServerResponse.this.statusMessage = LocalHttpServerResponse.EMPTY;
                }
            }
            return LocalHttpServerResponse.this.statusMessage;
        }

        public MultiMap headers() {
            return LocalHttpServerResponse.this.headers;
        }

        public String getHeader(String headerName) {
            return this.headers().get(headerName);
        }

        public String getHeader(CharSequence headerName) {
            return this.headers().get(headerName);
        }

        public String getTrailer(String trailerName) {
            throw new UnsupportedOperationException();
        }

        public MultiMap trailers() {
            throw new UnsupportedOperationException();
        }

        public List<String> cookies() {
            throw new UnsupportedOperationException();
        }

        public HttpClientResponse bodyHandler(Handler<Buffer> bodyHandler) {
            Buffer body = Buffer.buffer();
            this.handler((Handler<Buffer>)((Handler)arg_0 -> ((Buffer)body).appendBuffer(arg_0)));
            this.endHandler((Handler<Void>)((Handler)aVoid -> bodyHandler.handle((Object)body)));
            return this;
        }

        public HttpClientResponse customFrameHandler(Handler<HttpFrame> handler) {
            return this;
        }

        public NetSocket netSocket() {
            throw new UnsupportedOperationException();
        }

        public HttpClientRequest request() {
            return null;
        }

        public HttpClientResponse endHandler(Handler<Void> handler) {
            LocalHttpServerResponse.this.setEndHandler(handler);
            return this;
        }

        public HttpVersion version() {
            throw new UnsupportedOperationException();
        }

        public HttpClientResponse handler(Handler<Buffer> handler) {
            LocalHttpServerResponse.this.setDataHandler(handler);
            LocalHttpServerResponse.this.pump();
            return this;
        }

        public HttpClientResponse pause() {
            return this;
        }

        public HttpClientResponse resume() {
            return this;
        }

        public HttpClientResponse exceptionHandler(Handler<Throwable> handler) {
            return this;
        }
    };

    public LocalHttpServerResponse(Vertx vertx, Handler<HttpClientResponse> responseHandler) {
        super(vertx);
        this.responseHandler = responseHandler;
    }

    public int getStatusCode() {
        return this.statusCode;
    }

    public HttpServerResponse setStatusCode(int statusCode) {
        this.statusCode = statusCode;
        return this;
    }

    public String getStatusMessage() {
        if (this.statusMessage == null) {
            StatusCode code = StatusCode.fromCode(this.getStatusCode());
            this.statusMessage = code != null ? code.getStatusMessage() : EMPTY;
        }
        return this.statusMessage;
    }

    public HttpServerResponse setStatusMessage(String statusMessage) {
        this.statusMessage = statusMessage;
        return this;
    }

    public HttpServerResponse setChunked(boolean chunked) {
        return this;
    }

    public boolean isChunked() {
        return false;
    }

    public MultiMap headers() {
        return this.headers;
    }

    public HttpServerResponse putHeader(String name, String value) {
        this.headers().set(name, value);
        return this;
    }

    public HttpServerResponse putHeader(CharSequence name, CharSequence value) {
        this.headers().set(name, value);
        return this;
    }

    public HttpServerResponse putHeader(String name, Iterable<String> values) {
        for (String value : values) {
            this.headers().add(name, value);
        }
        return this;
    }

    public HttpServerResponse putHeader(CharSequence name, Iterable<CharSequence> values) {
        for (CharSequence value : values) {
            this.headers().add(name, value);
        }
        return this;
    }

    public MultiMap trailers() {
        throw new UnsupportedOperationException();
    }

    public HttpServerResponse putTrailer(String name, String value) {
        throw new UnsupportedOperationException();
    }

    public HttpServerResponse putTrailer(CharSequence name, CharSequence value) {
        throw new UnsupportedOperationException();
    }

    public HttpServerResponse putTrailer(String name, Iterable<String> values) {
        throw new UnsupportedOperationException();
    }

    public HttpServerResponse putTrailer(CharSequence name, Iterable<CharSequence> value) {
        throw new UnsupportedOperationException();
    }

    public HttpServerResponse closeHandler(Handler<Void> handler) {
        return this;
    }

    public HttpServerResponse endHandler(@Nullable Handler<Void> handler) {
        throw new UnsupportedOperationException();
    }

    public HttpServerResponse write(Buffer chunk) {
        this.ensureBound();
        this.doWrite(chunk);
        return this;
    }

    private void ensureBound() {
        if (!this.bound) {
            this.bound = true;
            if (this.statusCode == 0) {
                this.statusCode = 200;
                this.statusMessage = "OK";
            }
            this.responseHandler.handle((Object)this.clientResponse);
        }
    }

    public HttpServerResponse write(String chunk, String enc) {
        this.write(Buffer.buffer((String)chunk, (String)enc));
        return this;
    }

    public HttpServerResponse write(String chunk) {
        this.write(Buffer.buffer((String)chunk));
        return this;
    }

    public HttpServerResponse writeContinue() {
        throw new UnsupportedOperationException();
    }

    public void end(String chunk) {
        this.write(chunk);
        this.end();
    }

    public void end(String chunk, String enc) {
        this.write(chunk, enc);
        this.end();
    }

    public void end(Buffer chunk) {
        this.write(chunk);
        this.end();
    }

    public void end() {
        this.ensureBound();
        this.doEnd();
    }

    public HttpServerResponse sendFile(String filename) {
        throw new UnsupportedOperationException();
    }

    public HttpServerResponse sendFile(String filename, long offset) {
        throw new UnsupportedOperationException();
    }

    public HttpServerResponse sendFile(String filename, long offset, long length) {
        throw new UnsupportedOperationException();
    }

    public HttpServerResponse sendFile(String filename, Handler<AsyncResult<Void>> resultHandler) {
        throw new UnsupportedOperationException();
    }

    public HttpServerResponse sendFile(String filename, long offset, long length, Handler<AsyncResult<Void>> resultHandler) {
        throw new UnsupportedOperationException();
    }

    public void close() {
    }

    public boolean ended() {
        throw new UnsupportedOperationException();
    }

    public boolean closed() {
        throw new UnsupportedOperationException();
    }

    public boolean headWritten() {
        throw new UnsupportedOperationException();
    }

    public HttpServerResponse headersEndHandler(Handler<Void> handler) {
        throw new UnsupportedOperationException();
    }

    public HttpServerResponse bodyEndHandler(Handler<Void> handler) {
        throw new UnsupportedOperationException();
    }

    public long bytesWritten() {
        throw new UnsupportedOperationException();
    }

    public int streamId() {
        throw new UnsupportedOperationException();
    }

    public HttpServerResponse push(HttpMethod method, String host, String path, Handler<AsyncResult<HttpServerResponse>> handler) {
        throw new UnsupportedOperationException();
    }

    public HttpServerResponse push(HttpMethod method, String path, MultiMap headers, Handler<AsyncResult<HttpServerResponse>> handler) {
        throw new UnsupportedOperationException();
    }

    public HttpServerResponse push(HttpMethod method, String path, Handler<AsyncResult<HttpServerResponse>> handler) {
        throw new UnsupportedOperationException();
    }

    public HttpServerResponse push(HttpMethod method, String host, String path, MultiMap headers, Handler<AsyncResult<HttpServerResponse>> handler) {
        throw new UnsupportedOperationException();
    }

    public void reset(long code) {
        throw new UnsupportedOperationException();
    }

    public HttpServerResponse writeCustomFrame(int type, int flags, Buffer payload) {
        throw new UnsupportedOperationException();
    }

    public HttpServerResponse setWriteQueueMaxSize(int maxSize) {
        return this;
    }

    public boolean writeQueueFull() {
        return false;
    }

    public HttpServerResponse drainHandler(Handler<Void> handler) {
        throw new UnsupportedOperationException();
    }

    public HttpServerResponse exceptionHandler(Handler<Throwable> handler) {
        this.setExceptionHandler(handler);
        return this;
    }
}

