/*
 * Decompiled with CFR 0.152.
 */
package org.swisspush.gateleen.core.http;

import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.buffer.Buffer;
import java.util.LinkedList;
import java.util.Queue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BufferBridge {
    private Handler<Buffer> dataHandler;
    private Handler<Void> endHandler;
    private Handler<Throwable> exceptionHandler;
    private Queue<Buffer> queue = new LinkedList<Buffer>();
    private boolean ended = false;
    private Vertx vertx;
    private final Logger log = LoggerFactory.getLogger(BufferBridge.class);

    public BufferBridge(Vertx vertx) {
        this.vertx = vertx;
    }

    protected void pump() {
        this.vertx.runOnContext((Handler)new Handler<Void>(){

            public void handle(Void event) {
                block5: {
                    try {
                        if (!BufferBridge.this.queue.isEmpty()) {
                            BufferBridge.this.log.trace("Pumping from queue");
                            BufferBridge.this.dataHandler.handle(BufferBridge.this.queue.poll());
                            BufferBridge.this.pump();
                        } else if (BufferBridge.this.ended && BufferBridge.this.endHandler != null) {
                            BufferBridge.this.log.trace("Ending from pump");
                            BufferBridge.this.endHandler.handle(null);
                        }
                    }
                    catch (Exception e) {
                        if (BufferBridge.this.exceptionHandler == null) break block5;
                        BufferBridge.this.exceptionHandler.handle((Object)e);
                    }
                }
            }
        });
    }

    protected void doWrite(Buffer chunk) {
        if (this.dataHandler != null && this.queue.isEmpty()) {
            this.log.trace("Writing directly to handler");
            try {
                this.dataHandler.handle((Object)chunk);
            }
            catch (Exception e) {
                if (this.exceptionHandler != null) {
                    this.exceptionHandler.handle((Object)e);
                }
            }
        } else {
            this.log.trace("Writing to queue");
            this.queue.offer(chunk);
        }
    }

    protected void doEnd() {
        this.ended = true;
        if (this.endHandler != null && this.queue.isEmpty()) {
            block3: {
                this.log.trace("Ending handler directly");
                try {
                    this.endHandler.handle(null);
                }
                catch (Exception e) {
                    if (this.exceptionHandler == null) break block3;
                    this.exceptionHandler.handle((Object)e);
                }
            }
            this.endHandler = null;
            this.dataHandler = null;
        }
    }

    public void setDataHandler(Handler<Buffer> dataHandler) {
        this.dataHandler = dataHandler;
    }

    public void setExceptionHandler(Handler<Throwable> exceptionHandler) {
        this.exceptionHandler = exceptionHandler;
    }

    public void setEndHandler(Handler<Void> endHandler) {
        this.endHandler = endHandler;
    }
}

