/*
 * Decompiled with CFR 0.152.
 */
package org.swisspush.gateleen.core.util;

public enum StatusCode {
    OK(200, "OK"),
    ACCEPTED(202, "Accepted"),
    NOT_MODIFIED(304, "Not Modified"),
    BAD_REQUEST(400, "Bad Request"),
    FORBIDDEN(403, "Forbidden"),
    NOT_FOUND(404, "Not Found"),
    METHOD_NOT_ALLOWED(405, "Method Not Allowed"),
    CONFLICT(409, "Conflict"),
    INTERNAL_SERVER_ERROR(500, "Internal Server Error"),
    BAD_GATEWAY(502, "Bad Gateway"),
    SERVICE_UNAVAILABLE(503, "Service Unavailable"),
    TIMEOUT(504, "Gateway Timeout"),
    INSUFFICIENT_STORAGE(507, "Insufficient Storage");

    private final int statusCode;
    private final String statusMessage;

    private StatusCode(int statusCode, String statusMessage) {
        this.statusCode = statusCode;
        this.statusMessage = statusMessage;
    }

    public int getStatusCode() {
        return this.statusCode;
    }

    public String getStatusMessage() {
        return this.statusMessage;
    }

    public String toString() {
        return this.statusCode + " " + this.statusMessage;
    }

    public static StatusCode fromCode(int code) {
        for (StatusCode statuscode : StatusCode.values()) {
            if (statuscode.getStatusCode() != code) continue;
            return statuscode;
        }
        return null;
    }
}

