/*
 * Decompiled with CFR 0.152.
 */
package org.swisspush.gateleen.core.lua;

import io.vertx.core.json.JsonArray;
import io.vertx.redis.RedisClient;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import org.apache.commons.codec.digest.DigestUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.swisspush.gateleen.core.lua.LuaScript;
import org.swisspush.gateleen.core.lua.RedisCommand;
import org.swisspush.gateleen.core.lua.RedisCommandDoNothing;

public class LuaScriptState {
    private LuaScript luaScriptType;
    private String script;
    private boolean logoutput = false;
    private String sha;
    private RedisClient redisClient;
    private Logger log = LoggerFactory.getLogger(LuaScriptState.class);

    public LuaScriptState(LuaScript luaScriptType, RedisClient redisClient, boolean logoutput) {
        this.luaScriptType = luaScriptType;
        this.redisClient = redisClient;
        this.logoutput = logoutput;
        this.composeLuaScript(luaScriptType);
        this.loadLuaScript(new RedisCommandDoNothing(), 0);
    }

    private void composeLuaScript(LuaScript luaScriptType) {
        this.log.info("read the lua script for script type: " + luaScriptType + " with logoutput: " + this.logoutput);
        this.script = this.readLuaScriptFromClasspath(luaScriptType);
        this.sha = DigestUtils.sha1Hex((String)this.script);
    }

    private String readLuaScriptFromClasspath(LuaScript luaScriptType) {
        StringBuilder sb;
        BufferedReader in = new BufferedReader(new InputStreamReader(this.getClass().getClassLoader().getResourceAsStream(luaScriptType.getFilename())));
        try {
            String line;
            sb = new StringBuilder();
            while ((line = in.readLine()) != null) {
                if (!this.logoutput && line.contains("redis.log(redis.LOG_NOTICE,")) continue;
                sb.append(line).append("\n");
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            try {
                in.close();
            }
            catch (IOException iOException) {}
        }
        return sb.toString();
    }

    public void loadLuaScript(RedisCommand redisCommand, int executionCounter) {
        int executionCounterIncr = ++executionCounter;
        this.redisClient.scriptExists(this.sha, resultArray -> {
            if (resultArray.failed()) {
                this.log.error("Error checking whether lua script exists", resultArray.cause());
                return;
            }
            Long exists = ((JsonArray)resultArray.result()).getLong(0);
            if (Long.valueOf(1L).equals(exists)) {
                this.log.debug("RedisStorage script already exists in redis cache: " + this.luaScriptType);
                redisCommand.exec(executionCounterIncr);
            } else {
                this.log.info("load lua script for script type: " + this.luaScriptType + " logutput: " + this.logoutput);
                this.redisClient.scriptLoad(this.script, stringAsyncResult -> {
                    String newSha = (String)stringAsyncResult.result();
                    this.log.info("got sha from redis for lua script: " + this.luaScriptType + ": " + newSha);
                    if (!newSha.equals(this.sha)) {
                        this.log.warn("the sha calculated by myself: " + this.sha + " doesn't match with the sha from redis: " + newSha + ". We use the sha from redis");
                    }
                    this.sha = newSha;
                    this.log.info("execute redis command for script type: " + this.luaScriptType + " with new sha: " + this.sha);
                    redisCommand.exec(executionCounterIncr);
                });
            }
        });
    }

    public String getScript() {
        return this.script;
    }

    public void setScript(String script) {
        this.script = script;
    }

    public boolean getLogoutput() {
        return this.logoutput;
    }

    public void setLogoutput(boolean logoutput) {
        this.logoutput = logoutput;
    }

    public String getSha() {
        return this.sha;
    }

    public void setSha(String sha) {
        this.sha = sha;
    }
}

