/*
 * Decompiled with CFR 0.152.
 */
package org.swisspush.gateleen.core.util;

import io.vertx.core.MultiMap;
import io.vertx.core.http.HttpServerRequest;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class RoleExtractor {
    private static String groupHeader = "x-rp-grp";
    private static String roleHeader = "x-roles";
    private Pattern rolePattern;

    public RoleExtractor(String rolePattern) {
        this.rolePattern = Pattern.compile(rolePattern);
    }

    public Set<String> extractRoles(HttpServerRequest request) {
        HashSet<String> roles = null;
        MultiMap headers = request.headers();
        String proxyGroupHeader = headers.get(groupHeader);
        String userRoles = null;
        userRoles = proxyGroupHeader != null ? proxyGroupHeader : headers.get(roleHeader);
        if (userRoles != null) {
            roles = new HashSet<String>();
            HashSet<String> allRoles = new HashSet<String>(Arrays.asList(userRoles.split(",")));
            for (String r : allRoles) {
                r = r.trim();
                Matcher matcher = this.rolePattern.matcher(r = r.toLowerCase());
                if (!matcher.matches()) continue;
                roles.add(matcher.group(1));
            }
        }
        return roles;
    }
}

