/*
 * Decompiled with CFR 0.152.
 */
package org.swisspush.gateleen.core.cors;

import io.vertx.core.http.HttpMethod;
import io.vertx.core.http.HttpServerRequest;
import org.slf4j.Logger;
import org.swisspush.gateleen.core.http.RequestLoggerFactory;
import org.swisspush.gateleen.core.util.StatusCode;

public class CORSHandler {
    private boolean addCORSheaders = Boolean.parseBoolean(System.getProperty("org.swisspush.gateleen.addcorsheaders"));

    public boolean isOptionsRequest(HttpServerRequest request) {
        return HttpMethod.OPTIONS == request.method();
    }

    public void handle(HttpServerRequest request) {
        Logger log = RequestLoggerFactory.getLogger(CORSHandler.class, request);
        this.addCORSHeaders(request, log);
        if (this.isOptionsRequest(request)) {
            log.info("Got OPTIONS request. Respond with statusCode 200");
            request.response().setStatusCode(StatusCode.OK.getStatusCode());
            request.response().end();
        }
    }

    private void addCORSHeaders(HttpServerRequest request, Logger log) {
        String originHeader = request.headers().get("Origin");
        if (this.addCORSheaders && originHeader != null) {
            request.response().headers().set("Access-Control-Allow-Origin", originHeader);
            request.response().headers().set("Access-Control-Allow-Credentials", "true");
            request.response().headers().set("Access-Control-Allow-Methods", "GET, POST, OPTIONS, PUT, DELETE");
            if (HttpMethod.OPTIONS == request.method()) {
                request.response().headers().set("Access-Control-Allow-Headers", request.headers().get("Access-Control-Request-Headers"));
            }
            log.debug("Setting Access-Control-Allow-Origin headers");
        }
    }
}

