/*
 * Decompiled with CFR 0.152.
 */
package org.swisspush.gateleen.core.configuration;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.swisspush.gateleen.core.configuration.ConfigurationResourceManager;
import org.swisspush.gateleen.core.configuration.ConfigurationResourceObserver;
import org.swisspush.gateleen.core.util.ResourcesUtils;
import org.swisspush.gateleen.core.util.StringUtils;

public abstract class ConfigurationResourceConsumer
implements ConfigurationResourceObserver {
    private final Logger log = LoggerFactory.getLogger(ConfigurationResourceConsumer.class);
    private final ConfigurationResourceManager configurationResourceManager;
    private final String configResourceUri;
    private final String schemaResourceName;

    public ConfigurationResourceConsumer(ConfigurationResourceManager configurationResourceManager, String configResourceUri, String schemaResourceName) {
        this.configurationResourceManager = configurationResourceManager;
        this.configResourceUri = configResourceUri;
        this.schemaResourceName = schemaResourceName;
        this.initialize();
    }

    private void initialize() {
        if (this.configurationResourceManager != null && StringUtils.isNotEmptyTrimmed(this.configResourceUri) && StringUtils.isNotEmptyTrimmed(this.schemaResourceName)) {
            this.log.info("Register resource and observer for config resource uri " + this.configResourceUri);
            String schema = ResourcesUtils.loadResource(this.schemaResourceName, true);
            this.configurationResourceManager.registerResource(this.configResourceUri, schema);
            this.configurationResourceManager.registerObserver(this, this.configResourceUri);
        } else {
            this.log.warn("No configuration resource manager and/or no configuration resource uri and/or no schema resource name defined. Not using this feature in this case");
        }
    }

    public ConfigurationResourceManager configurationResourceManager() {
        return this.configurationResourceManager;
    }

    public String configResourceUri() {
        return this.configResourceUri;
    }

    public String schemaResourceName() {
        return this.schemaResourceName;
    }
}

