/*
 * Decompiled with CFR 0.152.
 */
package org.swisspush.gateleen.core.util;

import com.floreysoft.jmte.DefaultModelAdaptor;
import com.floreysoft.jmte.Engine;
import com.floreysoft.jmte.ErrorHandler;
import com.floreysoft.jmte.ModelAdaptor;
import com.floreysoft.jmte.TemplateContext;
import com.floreysoft.jmte.message.ParseException;
import com.floreysoft.jmte.token.Token;
import java.util.List;
import java.util.Map;

public final class StringUtils {
    private StringUtils() {
    }

    public static boolean isEmpty(CharSequence cs) {
        return cs == null || cs.length() == 0;
    }

    public static boolean isNotEmpty(CharSequence cs) {
        return !StringUtils.isEmpty(cs);
    }

    public static boolean isNotEmptyTrimmed(String str) {
        return !StringUtils.isEmpty(StringUtils.trim(str));
    }

    public static String trim(String str) {
        return str == null ? null : str.trim();
    }

    public static String getStringOrEmpty(String inputString) {
        if (StringUtils.isEmpty(inputString)) {
            return "";
        }
        return StringUtils.trim(inputString);
    }

    public static String getStringOrDefault(String inputString, String def) {
        String stringOrEmpty = StringUtils.getStringOrEmpty(inputString);
        if (StringUtils.isEmpty(stringOrEmpty)) {
            return def;
        }
        return stringOrEmpty;
    }

    public static String replaceWildcardConfigs(String contentWithWildcards, Map<String, Object> properties) {
        if (properties == null || contentWithWildcards == null) {
            return contentWithWildcards;
        }
        Engine engine = new Engine();
        engine.setModelAdaptor((ModelAdaptor)new DefaultModelAdaptor(){

            public Object getValue(TemplateContext context, Token arg1, List<String> arg2, String expression) {
                Object value = context.model.get((Object)expression);
                if (value != null) {
                    return value;
                }
                return super.getValue(context, arg1, arg2, expression);
            }

            protected Object traverse(Object obj, List<String> arg1, int arg2, ErrorHandler arg3, Token token) {
                if (obj == null) {
                    throw new IllegalArgumentException("Could not resolve " + token);
                }
                return super.traverse(obj, arg1, arg2, arg3, token);
            }
        });
        try {
            return engine.transform(contentWithWildcards, properties);
        }
        catch (ParseException e) {
            throw new IllegalArgumentException(e);
        }
    }
}

