/*
 * Decompiled with CFR 0.152.
 */
package org.swisspush.gateleen.core.configuration;

import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.http.HttpServerRequest;
import io.vertx.core.json.JsonObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.swisspush.gateleen.core.configuration.ConfigurationResourceObserver;
import org.swisspush.gateleen.core.configuration.ConfigurationResourceValidator;
import org.swisspush.gateleen.core.http.RequestLoggerFactory;
import org.swisspush.gateleen.core.logging.LoggableResource;
import org.swisspush.gateleen.core.logging.RequestLogger;
import org.swisspush.gateleen.core.storage.ResourceStorage;
import org.swisspush.gateleen.core.util.ResponseStatusCodeLogUtil;
import org.swisspush.gateleen.core.util.StatusCode;
import org.swisspush.gateleen.core.validation.ValidationResult;

public class ConfigurationResourceManager
implements LoggableResource {
    private Logger log = LoggerFactory.getLogger(ConfigurationResourceManager.class);
    private Vertx vertx;
    private ResourceStorage storage;
    private Map<String, String> registeredResources;
    private Map<String, List<ConfigurationResourceObserver>> observers;
    private ConfigurationResourceValidator configurationResourceValidator;
    private boolean logConfigurationResourceChanges = false;
    public static final String CONFIG_RESOURCE_CHANGED_ADDRESS = "gateleen.configuration-resource-changed";
    private static final String MESSAGE_REQUEST_URI = "requestUri";
    private static final String MESSAGE_RESOURCE_TYPE = "type";

    public ConfigurationResourceManager(Vertx vertx, ResourceStorage storage) {
        this.vertx = vertx;
        this.storage = storage;
        this.configurationResourceValidator = new ConfigurationResourceValidator(vertx);
        this.log.info("Register on vertx event bus to receive configuration resource updates");
        vertx.eventBus().consumer(CONFIG_RESOURCE_CHANGED_ADDRESS, event -> {
            String requestUri = ((JsonObject)event.body()).getString(MESSAGE_REQUEST_URI);
            ConfigurationResourceChangeType type = ConfigurationResourceChangeType.fromString(((JsonObject)event.body()).getString(MESSAGE_RESOURCE_TYPE));
            if (requestUri != null && type != null) {
                if (ConfigurationResourceChangeType.CHANGE == type) {
                    this.notifyObserverAboutResourceChange(requestUri, null);
                } else if (ConfigurationResourceChangeType.REMOVE == type) {
                    this.notifyObserversAboutRemovedResource(requestUri);
                } else {
                    this.log.warn("Not supported configuration resource change type '" + (Object)((Object)type) + "' received. Doing nothing with it");
                }
            } else {
                this.log.warn("Invalid configuration resource change message received. Don't notify anybody!");
            }
        });
    }

    public Future<Optional<Buffer>> getRegisteredResource(String resourceUri) {
        return this.getValidatedRegisteredResource(resourceUri);
    }

    public void registerResource(String resourceUri, String resourceSchema) {
        this.getRegisteredResources().put(resourceUri, resourceSchema);
    }

    public void registerObserver(ConfigurationResourceObserver observer, String resourceUri) {
        if (!this.getRegisteredResources().containsKey(resourceUri)) {
            this.log.warn("No registered resource with uri " + resourceUri + " found");
        }
        List<ConfigurationResourceObserver> observersByResourceUri = this.getObserversByResourceUri(resourceUri);
        observersByResourceUri.add(observer);
        this.observers.put(resourceUri, observersByResourceUri);
        this.notifyObserverAboutResourceChange(resourceUri, observer);
    }

    @Override
    public void enableResourceLogging(boolean resourceLoggingEnabled) {
        this.logConfigurationResourceChanges = resourceLoggingEnabled;
    }

    public boolean handleConfigurationResource(HttpServerRequest request) {
        Logger requestLog = RequestLoggerFactory.getLogger(ConfigurationResourceManager.class, request);
        if (null == this.getRegisteredResources().get(request.uri())) {
            return false;
        }
        String resourceUri = request.uri();
        String resourceSchema = this.getRegisteredResources().get(request.uri());
        if (HttpMethod.PUT == request.method()) {
            requestLog.info("Refresh resource " + resourceUri);
            request.bodyHandler(buffer -> this.configurationResourceValidator.validateConfigurationResource((Buffer)buffer, resourceSchema, (Handler<AsyncResult<ValidationResult>>)((Handler)event -> {
                if (event.failed() || event.succeeded() && !((ValidationResult)event.result()).isSuccess()) {
                    requestLog.error("Could not parse configuration resource for uri '" + resourceUri + "' message: " + ((ValidationResult)event.result()).getMessage());
                    request.response().setStatusCode(StatusCode.BAD_REQUEST.getStatusCode());
                    request.response().setStatusMessage(StatusCode.BAD_REQUEST.getStatusMessage() + " " + ((ValidationResult)event.result()).getMessage());
                    ResponseStatusCodeLogUtil.info(request, StatusCode.BAD_REQUEST, ConfigurationResourceManager.class);
                    if (((ValidationResult)event.result()).getValidationDetails() != null) {
                        request.response().headers().add("content-type", "application/json");
                        request.response().end(((ValidationResult)event.result()).getValidationDetails().encode());
                    } else {
                        request.response().end(((ValidationResult)event.result()).getMessage());
                    }
                } else {
                    this.storage.put(resourceUri, (Buffer)buffer, (Handler<Integer>)((Handler)status -> {
                        if (status.intValue() == StatusCode.OK.getStatusCode()) {
                            if (this.logConfigurationResourceChanges) {
                                RequestLogger.logRequest(this.vertx.eventBus(), request, status, buffer);
                            }
                            JsonObject object = new JsonObject();
                            object.put(MESSAGE_REQUEST_URI, resourceUri);
                            object.put(MESSAGE_RESOURCE_TYPE, (Enum)ConfigurationResourceChangeType.CHANGE);
                            this.vertx.eventBus().publish(CONFIG_RESOURCE_CHANGED_ADDRESS, (Object)object);
                        } else {
                            request.response().setStatusCode(status.intValue());
                        }
                        ResponseStatusCodeLogUtil.info(request, StatusCode.fromCode(status), ConfigurationResourceManager.class);
                        request.response().end();
                    }));
                }
            })));
            return true;
        }
        if (HttpMethod.DELETE == request.method()) {
            requestLog.info("Remove resource " + resourceUri);
            this.storage.delete(resourceUri, (Handler<Integer>)((Handler)status -> {
                if (status.intValue() == StatusCode.OK.getStatusCode()) {
                    JsonObject object = new JsonObject();
                    object.put(MESSAGE_REQUEST_URI, resourceUri);
                    object.put(MESSAGE_RESOURCE_TYPE, (Enum)ConfigurationResourceChangeType.REMOVE);
                    this.vertx.eventBus().publish(CONFIG_RESOURCE_CHANGED_ADDRESS, (Object)object);
                } else {
                    request.response().setStatusCode(status.intValue());
                }
                request.response().end();
            }));
            return true;
        }
        return false;
    }

    private Map<String, String> getRegisteredResources() {
        if (this.registeredResources == null) {
            this.registeredResources = new HashMap<String, String>();
        }
        return this.registeredResources;
    }

    public Map<String, List<ConfigurationResourceObserver>> getObservers() {
        if (this.observers == null) {
            this.observers = new HashMap<String, List<ConfigurationResourceObserver>>();
        }
        return this.observers;
    }

    private Future<Optional<Buffer>> getValidatedRegisteredResource(String resourceUri) {
        Future future = Future.future();
        String resourceSchema = this.getRegisteredResources().get(resourceUri);
        this.storage.get(resourceUri, (Handler<Buffer>)((Handler)buffer -> {
            if (buffer != null) {
                this.configurationResourceValidator.validateConfigurationResource((Buffer)buffer, resourceSchema, (Handler<AsyncResult<ValidationResult>>)((Handler)event -> {
                    if (event.succeeded()) {
                        if (((ValidationResult)event.result()).isSuccess()) {
                            future.complete(Optional.of(buffer));
                        } else {
                            future.fail("Failure during validation of resource " + resourceUri + ". Message: " + ((ValidationResult)event.result()).getMessage());
                        }
                    } else {
                        future.fail("Failure during validation of resource " + resourceUri + ". Message: " + event.cause());
                    }
                }));
            } else {
                future.complete(Optional.empty());
            }
        }));
        return future;
    }

    private void notifyObserversAboutRemovedResource(String requestUri) {
        this.log.debug("About to notify observers that resource " + requestUri + " has been removed");
        List<ConfigurationResourceObserver> observersByResourceUri = this.getObserversByResourceUri(requestUri);
        for (ConfigurationResourceObserver observer : observersByResourceUri) {
            observer.resourceRemoved(requestUri);
        }
    }

    private void notifyObserverAboutResourceChange(String requestUri, ConfigurationResourceObserver observer) {
        this.getValidatedRegisteredResource(requestUri).setHandler(event -> {
            if (event.failed()) {
                this.log.warn(event.cause().getMessage());
            } else if (((Optional)event.result()).isPresent()) {
                if (observer != null) {
                    observer.resourceChanged(requestUri, (Buffer)((Optional)event.result()).get());
                } else {
                    List<ConfigurationResourceObserver> observersByResourceUri = this.getObserversByResourceUri(requestUri);
                    for (ConfigurationResourceObserver configurationResourceObserver : observersByResourceUri) {
                        configurationResourceObserver.resourceChanged(requestUri, (Buffer)((Optional)event.result()).get());
                    }
                }
            } else {
                this.log.warn("Could not get URL '" + (requestUri == null ? "<null>" : requestUri) + "'.");
            }
        });
    }

    private List<ConfigurationResourceObserver> getObserversByResourceUri(String resourceUri) {
        List<ConfigurationResourceObserver> resourceObservers = this.getObservers().get(resourceUri);
        if (resourceObservers == null) {
            resourceObservers = new ArrayList<ConfigurationResourceObserver>();
        }
        return resourceObservers;
    }

    private static enum ConfigurationResourceChangeType {
        CHANGE,
        REMOVE;


        public static ConfigurationResourceChangeType fromString(String typeString) {
            for (ConfigurationResourceChangeType type : ConfigurationResourceChangeType.values()) {
                if (!type.name().equalsIgnoreCase(typeString)) continue;
                return type;
            }
            return null;
        }
    }
}

