/*
 * Decompiled with CFR 0.152.
 */
package org.swisspush.gateleen.core.util;

import io.vertx.core.http.HttpServerRequest;
import org.swisspush.gateleen.core.http.RequestLoggerFactory;
import org.swisspush.gateleen.core.util.StatusCode;

public final class ResponseStatusCodeLogUtil {
    private static final String SELF_REQUEST_HEADER = "x-self-request";

    private ResponseStatusCodeLogUtil() {
    }

    public static void debug(HttpServerRequest request, StatusCode statusCode, Class<?> caller) {
        ResponseStatusCodeLogUtil.debug(request, statusCode.getStatusCode(), statusCode.getStatusMessage(), caller);
    }

    public static void debug(HttpServerRequest request, int statusCode, String statusMessage, Class<?> caller) {
        if (request != null && statusMessage != null && caller != null && !request.headers().contains(SELF_REQUEST_HEADER)) {
            RequestLoggerFactory.getLogger(caller, request).debug(ResponseStatusCodeLogUtil.responseLogString(request, statusCode, statusMessage));
        }
        ResponseStatusCodeLogUtil.removeSelfRequestHeaders(request);
    }

    public static void info(HttpServerRequest request, StatusCode statusCode, Class<?> caller) {
        ResponseStatusCodeLogUtil.info(request, statusCode.getStatusCode(), statusCode.getStatusMessage(), caller);
    }

    public static void info(HttpServerRequest request, int statusCode, String statusMessage, Class<?> caller) {
        if (request != null && statusMessage != null && caller != null && !request.headers().contains(SELF_REQUEST_HEADER)) {
            RequestLoggerFactory.getLogger(caller, request).info(ResponseStatusCodeLogUtil.responseLogString(request, statusCode, statusMessage));
        }
        ResponseStatusCodeLogUtil.removeSelfRequestHeaders(request);
    }

    public static boolean isRequestToExternalTarget(String target) {
        boolean isInternalRequest = false;
        if (target != null) {
            isInternalRequest = target.contains("localhost") || target.contains("127.0.0.1");
        }
        return !isInternalRequest;
    }

    private static String responseLogString(HttpServerRequest request, int statusCode, String statusMessage) {
        return "Responding " + request.method() + " request to " + request.uri() + " with status code " + statusCode + " " + statusMessage;
    }

    private static void removeSelfRequestHeaders(HttpServerRequest request) {
        if (request != null) {
            request.headers().remove(SELF_REQUEST_HEADER);
        }
    }
}

