/*
 * Decompiled with CFR 0.152.
 */
package org.swisspush.gateleen.core.event;

import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;
import io.vertx.core.MultiMap;
import io.vertx.core.Vertx;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.eventbus.DeliveryOptions;
import io.vertx.core.eventbus.Message;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.http.HttpServerRequest;
import io.vertx.core.json.DecodeException;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.bridge.BridgeEventType;
import io.vertx.ext.web.Router;
import io.vertx.ext.web.handler.sockjs.BridgeOptions;
import io.vertx.ext.web.handler.sockjs.PermittedOptions;
import io.vertx.ext.web.handler.sockjs.SockJSHandler;
import io.vertx.ext.web.handler.sockjs.SockJSHandlerOptions;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.swisspush.gateleen.core.configuration.ConfigurationResourceConsumer;
import org.swisspush.gateleen.core.configuration.ConfigurationResourceManager;
import org.swisspush.gateleen.core.http.RequestLoggerFactory;
import org.swisspush.gateleen.core.json.JsonMultiMap;

public class EventBusHandler
extends ConfigurationResourceConsumer {
    public static final int ACCEPTED = 202;
    public static final String SYNC = "x-sync";
    public static final String TEXT = "text/";
    public static final String METHOD = "method";
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    public static final int BAD_REQUEST = 400;
    public static final String CONTENT_TYPE = "content-type";
    public static final String APPLICATION_JSON = "application/json";
    public static final String PAYLOAD = "payload";
    public static final String URI = "uri";
    public static final String HEADERS = "headers";
    public static final int TIMEOUT = 20000;
    public static final int GATEWAY_TIMEOUT = 504;
    private static final boolean DEFAULT_WEBSOCKET_CONNECTION_STATE = true;
    private Vertx vertx;
    private String apiPath;
    private String sockPath;
    private String addressPrefix;
    private Pattern adressPathPattern;
    private Long eventbusBridgePingInterval = null;
    private Long eventbusBridgeReplyTimeout = null;
    private Integer eventbusBridgeMaxAddressLength = null;
    private Integer eventbusBridgeMaxHandlersPerSocket = null;
    private boolean websocketConnectionsEnabled = true;
    private SockJSHandlerOptions sockJSHandlerOptions = null;

    public EventBusHandler(Vertx vertx, String apiPath, String sockPath, String addressPrefix, String addressPathPattern) {
        this(vertx, apiPath, sockPath, addressPrefix, addressPathPattern, null, null);
    }

    public EventBusHandler(Vertx vertx, String apiPath, String sockPath, String addressPrefix, String addressPathPattern, ConfigurationResourceManager configurationResourceManager, String configResourceUri) {
        super(configurationResourceManager, configResourceUri, "gateleen_core_schema_websocket");
        this.vertx = vertx;
        this.apiPath = apiPath;
        this.sockPath = sockPath;
        this.addressPrefix = addressPrefix;
        this.adressPathPattern = Pattern.compile(apiPath + addressPathPattern);
    }

    public boolean handle(final HttpServerRequest request) {
        final Logger requestLog = RequestLoggerFactory.getLogger(EventBusHandler.class, request);
        if (request.uri().startsWith(this.apiPath)) {
            requestLog.debug("Handling {}", (Object)request.uri());
            Matcher matcher = this.adressPathPattern.matcher(request.uri());
            if (matcher.matches()) {
                final String address = this.addressPrefix + matcher.group(1);
                final JsonObject message = new JsonObject().put(URI, request.uri()).put(METHOD, (Enum)request.method()).put(HEADERS, JsonMultiMap.toJson(request.headers()));
                requestLog.debug("Preparing message for address {}", (Object)address);
                request.bodyHandler((Handler)new Handler<Buffer>(){

                    public void handle(Buffer buffer) {
                        String contentType = request.headers().get(EventBusHandler.CONTENT_TYPE);
                        if (contentType == null) {
                            contentType = EventBusHandler.APPLICATION_JSON;
                        }
                        if (buffer != null && buffer.length() > 0) {
                            if (contentType.contains(EventBusHandler.APPLICATION_JSON)) {
                                try {
                                    message.put(EventBusHandler.PAYLOAD, new JsonObject(buffer.toString()));
                                }
                                catch (DecodeException e) {
                                    request.response().setStatusCode(400);
                                    request.response().end(e.getMessage());
                                    return;
                                }
                            } else if (contentType.contains(EventBusHandler.TEXT)) {
                                message.put(EventBusHandler.PAYLOAD, buffer.toString());
                            } else {
                                message.put(EventBusHandler.PAYLOAD, buffer.getBytes());
                            }
                        }
                        requestLog.debug("Request content type is {}", (Object)contentType);
                        if (HttpMethod.GET == request.method() || Boolean.TRUE.toString().equals(request.headers().get(EventBusHandler.SYNC))) {
                            requestLog.debug("This is a synchronous request");
                            EventBusHandler.this.vertx.eventBus().send(address, (Object)message, new DeliveryOptions().setSendTimeout(20000L), (Handler)new Handler<AsyncResult<Message<JsonObject>>>(){

                                public void handle(AsyncResult<Message<JsonObject>> reply) {
                                    block11: {
                                        if (reply.succeeded()) {
                                            requestLog.debug("Got response");
                                            JsonObject response = (JsonObject)((Message)reply.result()).body();
                                            MultiMap headers = null;
                                            try {
                                                if (response.fieldNames().contains(EventBusHandler.HEADERS)) {
                                                    headers = JsonMultiMap.fromJson(response.getJsonArray(EventBusHandler.HEADERS));
                                                    request.response().headers().setAll(headers);
                                                }
                                            }
                                            catch (DecodeException e) {
                                                requestLog.warn("Wrong headers in reply", (Throwable)e);
                                            }
                                            if (response.fieldNames().contains(EventBusHandler.PAYLOAD)) {
                                                String responseContentType = headers != null ? headers.get(EventBusHandler.CONTENT_TYPE) : EventBusHandler.APPLICATION_JSON;
                                                requestLog.debug("Response content type is {}", (Object)responseContentType);
                                                try {
                                                    request.response().setChunked(true);
                                                    if (responseContentType != null && responseContentType.contains(EventBusHandler.APPLICATION_JSON)) {
                                                        request.response().end(response.getJsonObject(EventBusHandler.PAYLOAD).encode());
                                                        break block11;
                                                    }
                                                    if (responseContentType != null && responseContentType.contains(EventBusHandler.TEXT)) {
                                                        request.response().end(response.getString(EventBusHandler.PAYLOAD));
                                                        break block11;
                                                    }
                                                    request.response().end(Buffer.buffer((byte[])response.getBinary(EventBusHandler.PAYLOAD)));
                                                }
                                                catch (DecodeException e) {
                                                    requestLog.warn("Wrong payload in reply for content-type " + responseContentType, (Throwable)e);
                                                    request.response().setStatusCode(500);
                                                    request.response().end("Wrong payload in reply for content-type " + responseContentType + ": ", e.getMessage());
                                                }
                                            } else {
                                                requestLog.debug("No payload in response");
                                                request.response().end();
                                            }
                                        } else {
                                            requestLog.debug("Timeout");
                                            request.response().setStatusCode(504);
                                            request.response().setChunked(true);
                                            request.response().end("Gateway Timeout");
                                        }
                                    }
                                }
                            });
                        } else {
                            requestLog.debug("This is an asynchronous request");
                            EventBusHandler.this.vertx.eventBus().publish(address, (Object)message);
                            request.response().setStatusCode(202);
                            request.response().end();
                        }
                    }
                });
                return true;
            }
        }
        return false;
    }

    public void install(Router router) {
        BridgeOptions bridgeOptions = this.buildBridgeOptions();
        router.route(this.sockPath).handler((Handler)SockJSHandler.create((Vertx)this.vertx, (SockJSHandlerOptions)this.getSockJSHandlerOptions()).bridge(bridgeOptions, be -> {
            this.log.debug("SockJS bridge event: {}", (Object)be.type().toString());
            if (!this.websocketConnectionsEnabled && BridgeEventType.SOCKET_CREATED == be.type()) {
                this.log.info("WebSocket connections are disabled. Not allowing another connection");
                be.complete((Object)false);
            } else {
                be.complete((Object)true);
            }
        }));
        this.log.info("Installed SockJS endpoint on {}", (Object)this.sockPath);
        this.log.info("Installed event bus bridge with options: {}", (Object)this.bridgeOptionsToString(bridgeOptions));
        this.log.info("Installed SockJS with handler options: {}", (Object)this.sockJSHandlerOptionsToString());
        this.log.info("Listening to requests on {}", (Object)this.adressPathPattern.pattern());
        this.log.info("Using address prefix {}", (Object)this.addressPrefix);
    }

    @Override
    public void resourceChanged(String resourceUri, Buffer resource) {
        if (this.configResourceUri() != null && this.configResourceUri().equals(resourceUri)) {
            this.log.info("Got notified about configuration resource update for {}", (Object)resourceUri);
            try {
                JsonObject obj = new JsonObject(resource);
                Boolean websockets_enabled = obj.getBoolean("websockets_enabled");
                if (websockets_enabled != null) {
                    this.websocketConnectionsEnabled = websockets_enabled;
                } else {
                    this.log.warn("No value for property 'websockets_enabled' found. Therefore not changing any configuration");
                }
            }
            catch (DecodeException ex) {
                this.log.warn("Unable to decode configuration resource for {}. Reason: {}", (Object)resourceUri, (Object)ex.getMessage());
            }
        }
    }

    @Override
    public void resourceRemoved(String resourceUri) {
        if (this.configResourceUri() != null && this.configResourceUri().equals(resourceUri)) {
            this.log.info("Configuration resource {} was removed. Using default values instead", (Object)resourceUri);
            this.websocketConnectionsEnabled = true;
        }
    }

    public void setEventbusBridgePingInterval(Long eventbusBridgePingInterval) {
        this.eventbusBridgePingInterval = eventbusBridgePingInterval;
    }

    public void setEventbusBridgeReplyTimeout(Long eventbusBridgeReplyTimeout) {
        this.eventbusBridgeReplyTimeout = eventbusBridgeReplyTimeout;
    }

    public void setEventbusBridgeMaxAddressLength(Integer eventbusBridgeMaxAddressLength) {
        this.eventbusBridgeMaxAddressLength = eventbusBridgeMaxAddressLength;
    }

    public void setEventbusBridgeMaxHandlersPerSocket(Integer eventbusBridgeMaxHandlersPerSocket) {
        this.eventbusBridgeMaxHandlersPerSocket = eventbusBridgeMaxHandlersPerSocket;
    }

    public void setSockJSHandlerOptions(SockJSHandlerOptions sockJSHandlerOptions) {
        if (sockJSHandlerOptions == null) {
            this.log.warn("Null provided instead of valid SockJSHandlerOptions. Using default values instead");
        }
        this.sockJSHandlerOptions = sockJSHandlerOptions;
    }

    public SockJSHandlerOptions getSockJSHandlerOptions() {
        if (this.sockJSHandlerOptions == null) {
            this.sockJSHandlerOptions = new SockJSHandlerOptions();
        }
        return this.sockJSHandlerOptions;
    }

    private BridgeOptions buildBridgeOptions() {
        BridgeOptions bridgeOptions = new BridgeOptions().addOutboundPermitted(new PermittedOptions().setAddressRegex(this.addressPrefix + "(.*)"));
        if (this.eventbusBridgePingInterval != null) {
            bridgeOptions = bridgeOptions.setPingTimeout(this.eventbusBridgePingInterval.longValue());
        }
        if (this.eventbusBridgeReplyTimeout != null) {
            bridgeOptions = bridgeOptions.setReplyTimeout(this.eventbusBridgeReplyTimeout.longValue());
        }
        if (this.eventbusBridgeMaxAddressLength != null) {
            bridgeOptions = bridgeOptions.setMaxAddressLength(this.eventbusBridgeMaxAddressLength.intValue());
        }
        if (this.eventbusBridgeMaxHandlersPerSocket != null) {
            bridgeOptions = bridgeOptions.setMaxHandlersPerSocket(this.eventbusBridgeMaxHandlersPerSocket.intValue());
        }
        return bridgeOptions;
    }

    private String sockJSHandlerOptionsToString() {
        SockJSHandlerOptions options = this.getSockJSHandlerOptions();
        return "heartbeatInterval=" + options.getHeartbeatInterval() + " maxBytesStreaming=" + options.getMaxBytesStreaming() + " sessionTimeout=" + options.getSessionTimeout() + " insertJSESSIONID=" + options.isInsertJSESSIONID() + " libraryURL=" + options.getLibraryURL();
    }

    private String bridgeOptionsToString(BridgeOptions options) {
        return "maxAddressLength=" + options.getMaxAddressLength() + " maxHandlersPerSocket=" + options.getMaxHandlersPerSocket() + " pingTimeout=" + options.getPingTimeout() + " replyTimeout=" + options.getReplyTimeout();
    }
}

