/*
 * Decompiled with CFR 0.152.
 */
package org.swisspush.gateleen.core.http;

import io.netty.handler.codec.http.QueryStringDecoder;
import io.vertx.codegen.annotations.Nullable;
import io.vertx.core.Handler;
import io.vertx.core.MultiMap;
import io.vertx.core.Vertx;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.HttpClientRequest;
import io.vertx.core.http.HttpConnection;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.http.HttpServerRequest;
import io.vertx.core.http.HttpServerResponse;
import io.vertx.core.http.HttpVersion;
import io.vertx.core.http.impl.headers.VertxHttpHeaders;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.core.net.NetSocket;
import io.vertx.core.net.SocketAddress;
import io.vertx.core.net.impl.SocketAddressImpl;
import io.vertx.ext.auth.User;
import io.vertx.ext.web.Cookie;
import io.vertx.ext.web.FileUpload;
import io.vertx.ext.web.LanguageHeader;
import io.vertx.ext.web.Locale;
import io.vertx.ext.web.ParsedHeaderValues;
import io.vertx.ext.web.Route;
import io.vertx.ext.web.RoutingContext;
import io.vertx.ext.web.Session;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.net.ssl.SSLSession;
import javax.security.cert.X509Certificate;
import org.swisspush.gateleen.core.http.BufferBridge;
import org.swisspush.gateleen.core.http.FastFailHttpClientRequest;
import org.swisspush.gateleen.core.http.FastFailHttpServerRequest;
import org.swisspush.gateleen.core.http.LocalHttpConnection;
import org.swisspush.gateleen.core.http.UriParser;

public class LocalHttpClientRequest
extends BufferBridge
implements FastFailHttpClientRequest {
    private MultiMap headers = new VertxHttpHeaders();
    private MultiMap params;
    private HttpMethod method;
    private String uri;
    private String path;
    private String query;
    private HttpServerResponse serverResponse;
    private final HttpConnection connection;
    private Handler<RoutingContext> routingContextHandler;
    private boolean bound = false;
    private static final SocketAddress address = new SocketAddressImpl(0, "localhost");
    private HttpServerRequest serverRequest = new FastFailHttpServerRequest(){

        @Override
        public HttpVersion version() {
            return HttpVersion.HTTP_1_0;
        }

        @Override
        public HttpMethod method() {
            return LocalHttpClientRequest.this.method;
        }

        @Override
        public boolean isSSL() {
            return false;
        }

        @Override
        public String uri() {
            return LocalHttpClientRequest.this.uri;
        }

        @Override
        public String path() {
            if (LocalHttpClientRequest.this.path == null) {
                LocalHttpClientRequest.this.path = UriParser.path(this.uri());
            }
            return LocalHttpClientRequest.this.path;
        }

        @Override
        public String query() {
            if (LocalHttpClientRequest.this.query == null) {
                LocalHttpClientRequest.this.query = UriParser.query(this.uri());
            }
            return LocalHttpClientRequest.this.query;
        }

        @Override
        public MultiMap params() {
            if (LocalHttpClientRequest.this.params == null) {
                QueryStringDecoder queryStringDecoder = new QueryStringDecoder(this.uri());
                Map prms = queryStringDecoder.parameters();
                LocalHttpClientRequest.this.params = new VertxHttpHeaders();
                if (!prms.isEmpty()) {
                    for (Map.Entry entry : prms.entrySet()) {
                        LocalHttpClientRequest.this.params.add((String)entry.getKey(), (Iterable)entry.getValue());
                    }
                }
            }
            return LocalHttpClientRequest.this.params;
        }

        @Override
        public String getParam(String paramName) {
            return this.params().get(paramName);
        }

        @Override
        public MultiMap headers() {
            return LocalHttpClientRequest.this.headers;
        }

        @Override
        public String getHeader(String headerName) {
            return this.headers().get(headerName);
        }

        @Override
        public String getHeader(CharSequence headerName) {
            return this.headers().get(headerName);
        }

        @Override
        public SocketAddress remoteAddress() {
            return address;
        }

        @Override
        public SocketAddress localAddress() {
            return address;
        }

        @Override
        public SSLSession sslSession() {
            return null;
        }

        @Override
        public X509Certificate[] peerCertificateChain() {
            return new X509Certificate[0];
        }

        @Override
        public String absoluteURI() {
            return "local:" + LocalHttpClientRequest.this.uri;
        }

        @Override
        public NetSocket netSocket() {
            return null;
        }

        @Override
        public HttpServerRequest setExpectMultipart(boolean expect) {
            return null;
        }

        @Override
        public boolean isExpectMultipart() {
            return false;
        }

        @Override
        public HttpConnection connection() {
            return LocalHttpClientRequest.this.connection;
        }

        @Override
        public HttpServerRequest endHandler(Handler<Void> handler) {
            LocalHttpClientRequest.this.setEndHandler(handler);
            return this;
        }

        @Override
        public HttpServerRequest handler(Handler<Buffer> handler) {
            LocalHttpClientRequest.this.setDataHandler(handler);
            LocalHttpClientRequest.this.pump();
            return this;
        }

        @Override
        public HttpServerRequest pause() {
            return this;
        }

        @Override
        public HttpServerRequest resume() {
            return this;
        }

        @Override
        public HttpServerResponse response() {
            return LocalHttpClientRequest.this.serverResponse;
        }

        @Override
        public HttpServerRequest exceptionHandler(Handler<Throwable> handler) {
            return this;
        }

        @Override
        public boolean isEnded() {
            return false;
        }
    };
    private RoutingContext routingContext = new RoutingContext(){

        public HttpServerRequest request() {
            return LocalHttpClientRequest.this.serverRequest;
        }

        public HttpServerResponse response() {
            return LocalHttpClientRequest.this.serverResponse;
        }

        public void next() {
            throw new UnsupportedOperationException();
        }

        public void fail(int statusCode) {
            throw new UnsupportedOperationException();
        }

        public void fail(Throwable throwable) {
            throw new UnsupportedOperationException();
        }

        public RoutingContext put(String key, Object obj) {
            throw new UnsupportedOperationException();
        }

        public <T> T get(String key) {
            throw new UnsupportedOperationException();
        }

        public <T> T remove(String key) {
            throw new UnsupportedOperationException();
        }

        public Map<String, Object> data() {
            throw new UnsupportedOperationException();
        }

        public Vertx vertx() {
            throw new UnsupportedOperationException();
        }

        public String mountPoint() {
            throw new UnsupportedOperationException();
        }

        public Route currentRoute() {
            throw new UnsupportedOperationException();
        }

        public String normalisedPath() {
            throw new UnsupportedOperationException();
        }

        public Cookie getCookie(String name) {
            throw new UnsupportedOperationException();
        }

        public RoutingContext addCookie(Cookie cookie) {
            throw new UnsupportedOperationException();
        }

        public Cookie removeCookie(String name) {
            throw new UnsupportedOperationException();
        }

        public @Nullable Cookie removeCookie(String s, boolean b) {
            throw new UnsupportedOperationException();
        }

        public int cookieCount() {
            throw new UnsupportedOperationException();
        }

        public Set<Cookie> cookies() {
            throw new UnsupportedOperationException();
        }

        public String getBodyAsString() {
            throw new UnsupportedOperationException();
        }

        public String getBodyAsString(String encoding) {
            throw new UnsupportedOperationException();
        }

        public JsonObject getBodyAsJson() {
            throw new UnsupportedOperationException();
        }

        public JsonArray getBodyAsJsonArray() {
            throw new UnsupportedOperationException();
        }

        public Buffer getBody() {
            throw new UnsupportedOperationException();
        }

        public Set<FileUpload> fileUploads() {
            throw new UnsupportedOperationException();
        }

        public Session session() {
            throw new UnsupportedOperationException();
        }

        public User user() {
            throw new UnsupportedOperationException();
        }

        public Throwable failure() {
            throw new UnsupportedOperationException();
        }

        public int statusCode() {
            throw new UnsupportedOperationException();
        }

        public String getAcceptableContentType() {
            throw new UnsupportedOperationException();
        }

        public ParsedHeaderValues parsedHeaders() {
            throw new UnsupportedOperationException();
        }

        public int addHeadersEndHandler(Handler<Void> handler) {
            throw new UnsupportedOperationException();
        }

        public boolean removeHeadersEndHandler(int handlerID) {
            throw new UnsupportedOperationException();
        }

        public int addBodyEndHandler(Handler<Void> handler) {
            throw new UnsupportedOperationException();
        }

        public boolean removeBodyEndHandler(int handlerID) {
            throw new UnsupportedOperationException();
        }

        public boolean failed() {
            throw new UnsupportedOperationException();
        }

        public void setBody(Buffer body) {
            throw new UnsupportedOperationException();
        }

        public void setSession(Session session) {
            throw new UnsupportedOperationException();
        }

        public void setUser(User user) {
            throw new UnsupportedOperationException();
        }

        public void clearUser() {
            throw new UnsupportedOperationException();
        }

        public void setAcceptableContentType(String contentType) {
            throw new UnsupportedOperationException();
        }

        public void reroute(String path) {
            throw new UnsupportedOperationException();
        }

        public void reroute(HttpMethod method, String path) {
            throw new UnsupportedOperationException();
        }

        public List<Locale> acceptableLocales() {
            throw new UnsupportedOperationException();
        }

        public List<LanguageHeader> acceptableLanguages() {
            throw new UnsupportedOperationException();
        }

        public Locale preferredLocale() {
            throw new UnsupportedOperationException();
        }

        public LanguageHeader preferredLanguage() {
            throw new UnsupportedOperationException();
        }

        public Map<String, String> pathParams() {
            throw new UnsupportedOperationException();
        }

        public @Nullable String pathParam(String name) {
            throw new UnsupportedOperationException();
        }

        public MultiMap queryParams() {
            throw new UnsupportedOperationException();
        }

        public @Nullable List<String> queryParam(String query) {
            throw new UnsupportedOperationException();
        }
    };

    public LocalHttpClientRequest(HttpMethod method, String uri, Vertx vertx, Handler<RoutingContext> routingContextHandler, HttpServerResponse response) {
        super(vertx);
        this.method = method;
        this.uri = uri;
        this.routingContextHandler = routingContextHandler;
        this.serverResponse = response;
        this.connection = new LocalHttpConnection();
    }

    @Override
    public HttpClientRequest setChunked(boolean chunked) {
        return this;
    }

    @Override
    public boolean isChunked() {
        return false;
    }

    @Override
    public HttpMethod method() {
        return this.method;
    }

    @Override
    public String getRawMethod() {
        return null;
    }

    @Override
    public HttpClientRequest setRawMethod(String method) {
        return this;
    }

    @Override
    public String absoluteURI() {
        return null;
    }

    @Override
    public String uri() {
        return this.uri;
    }

    @Override
    public String path() {
        return null;
    }

    @Override
    public String query() {
        return null;
    }

    @Override
    public HttpClientRequest setHost(String host) {
        return this;
    }

    @Override
    public String getHost() {
        return null;
    }

    @Override
    public MultiMap headers() {
        return this.headers;
    }

    @Override
    public HttpClientRequest putHeader(String name, String value) {
        this.headers().set(name, value);
        return this;
    }

    @Override
    public HttpClientRequest putHeader(CharSequence name, CharSequence value) {
        this.headers().set(name, value);
        return this;
    }

    @Override
    public HttpClientRequest putHeader(String name, Iterable<String> values) {
        for (String value : values) {
            this.headers().add(name, value);
        }
        return this;
    }

    @Override
    public HttpClientRequest putHeader(CharSequence name, Iterable<CharSequence> values) {
        for (CharSequence value : values) {
            this.headers().add(name, value);
        }
        return this;
    }

    @Override
    public HttpClientRequest write(Buffer chunk) {
        this.ensureBound();
        this.doWrite(chunk);
        return this;
    }

    private void ensureBound() {
        if (!this.bound) {
            this.bound = true;
            this.routingContextHandler.handle((Object)this.routingContext);
        }
    }

    @Override
    public HttpClientRequest write(String chunk) {
        this.write(Buffer.buffer((String)chunk));
        return this;
    }

    @Override
    public HttpClientRequest write(String chunk, String enc) {
        this.write(Buffer.buffer((String)chunk, (String)enc));
        return this;
    }

    @Override
    public HttpClientRequest sendHead() {
        return this;
    }

    @Override
    public HttpClientRequest sendHead(Handler<HttpVersion> completionHandler) {
        return this;
    }

    @Override
    public void end(String chunk) {
        this.write(chunk);
        this.end();
    }

    @Override
    public void end(String chunk, String enc) {
        this.write(chunk, enc);
        this.end();
    }

    @Override
    public void end(Buffer chunk) {
        this.write(chunk);
        this.end();
    }

    @Override
    public void end() {
        this.ensureBound();
        this.doEnd();
    }

    @Override
    public HttpClientRequest setTimeout(long timeoutMs) {
        return this;
    }

    @Override
    public HttpClientRequest pushHandler(Handler<HttpClientRequest> handler) {
        return this;
    }

    public boolean reset() {
        return false;
    }

    @Override
    public boolean reset(long code) {
        return false;
    }

    @Override
    public HttpConnection connection() {
        return null;
    }

    @Override
    public HttpClientRequest connectionHandler(@Nullable Handler<HttpConnection> handler) {
        return this;
    }

    @Override
    public HttpClientRequest writeCustomFrame(int type, int flags, Buffer payload) {
        return this;
    }

    @Override
    public HttpClientRequest setWriteQueueMaxSize(int maxSize) {
        return this;
    }

    @Override
    public boolean writeQueueFull() {
        return false;
    }

    @Override
    public HttpClientRequest drainHandler(Handler<Void> handler) {
        return this;
    }

    @Override
    public HttpClientRequest exceptionHandler(Handler<Throwable> handler) {
        this.setExceptionHandler(handler);
        return this;
    }

    public void setMethod(HttpMethod method) {
        this.method = method;
    }

    public void setUri(String uri) {
        this.uri = uri;
    }
}

