/*
 * Decompiled with CFR 0.152.
 */
package org.swisspush.gateleen.core.lock.impl;

import io.vertx.core.Future;
import io.vertx.redis.RedisClient;
import io.vertx.redis.op.SetOptions;
import java.util.Collections;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.swisspush.gateleen.core.lock.Lock;
import org.swisspush.gateleen.core.lock.lua.LockLuaScripts;
import org.swisspush.gateleen.core.lock.lua.ReleaseLockRedisCommand;
import org.swisspush.gateleen.core.lua.LuaScriptState;

public class RedisBasedLock
implements Lock {
    private RedisClient redisClient;
    private Logger log = LoggerFactory.getLogger(RedisBasedLock.class);
    public static final String STORAGE_PREFIX = "gateleen.core-lock:";
    private LuaScriptState releaseLockLuaScriptState;

    public RedisBasedLock(RedisClient redisClient) {
        this.redisClient = redisClient;
        this.releaseLockLuaScriptState = new LuaScriptState(LockLuaScripts.LOCK_RELEASE, redisClient, false);
    }

    @Override
    public Future<Boolean> acquireLock(String lock, String token, long lockExpiryMs) {
        Future future = Future.future();
        this.redisClient.setWithOptions(this.buildLockKey(lock), token, new SetOptions().setNX(true).setPX(lockExpiryMs), event -> {
            if (event.succeeded()) {
                future.complete((Object)"OK".equalsIgnoreCase((String)event.result()));
            } else {
                future.fail(event.cause().getMessage());
            }
        });
        return future;
    }

    @Override
    public Future<Boolean> releaseLock(String lock, String token) {
        Future future = Future.future();
        List<String> keys = Collections.singletonList(this.buildLockKey(lock));
        List<String> arguments = Collections.singletonList(token);
        ReleaseLockRedisCommand cmd = new ReleaseLockRedisCommand(this.releaseLockLuaScriptState, keys, arguments, this.redisClient, this.log, (Future<Boolean>)future);
        cmd.exec(0);
        return future;
    }

    private String buildLockKey(String lock) {
        return STORAGE_PREFIX + lock;
    }
}

