/*
 * Decompiled with CFR 0.152.
 */
package org.swisspush.gateleen.core.util;

import io.vertx.core.Future;
import org.slf4j.Logger;
import org.swisspush.gateleen.core.lock.Lock;

public class LockUtil {
    private LockUtil() {
    }

    public static Future<Boolean> acquireLock(Lock lockImpl, String lock, String token, long lockExpiryMs, Logger log) {
        Future future = Future.future();
        if (lockImpl == null) {
            log.info("No lock implementation defined, going to pretend like we got the lock");
            future.complete((Object)Boolean.TRUE);
            return future;
        }
        log.debug("Trying to acquire lock '{}' with token '{}' and expiry {}ms", new Object[]{lock, token, lockExpiryMs});
        lockImpl.acquireLock(lock, token, lockExpiryMs).setHandler(lockEvent -> {
            if (lockEvent.succeeded()) {
                if (((Boolean)lockEvent.result()).booleanValue()) {
                    log.debug("Acquired lock '{}' with token '{}'", (Object)lock, (Object)token);
                    future.complete((Object)Boolean.TRUE);
                } else {
                    future.complete((Object)Boolean.FALSE);
                }
            } else {
                future.fail(lockEvent.cause());
            }
        });
        return future;
    }

    public static void releaseLock(Lock lockImpl, String lock, String token, Logger log) {
        if (lockImpl == null) {
            log.info("No lock implementation defined, going to pretend like we released the lock");
            return;
        }
        log.debug("Trying to release lock '{}' with token '{}'", (Object)lock, (Object)token);
        lockImpl.releaseLock(lock, token).setHandler(releaseEvent -> {
            if (releaseEvent.succeeded()) {
                if (((Boolean)releaseEvent.result()).booleanValue()) {
                    log.debug("Released lock '{}' with token '{}'", (Object)lock, (Object)token);
                }
            } else {
                log.error("Could not release lock '{}'. Message: {}", (Object)lock, (Object)releaseEvent.cause().getMessage());
            }
        });
    }
}

