/*
 * Decompiled with CFR 0.152.
 */
package org.swisspush.gateleen.core.util;

import io.vertx.core.MultiMap;
import io.vertx.core.http.HttpServerRequest;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class RoleExtractor {
    public static final String groupHeader = "x-rp-grp";
    public static final String roleHeader = "x-roles";
    private Pattern rolePattern;

    public RoleExtractor(String rolePattern) {
        this.rolePattern = Pattern.compile(rolePattern);
    }

    public RoleExtractor() {
        this.rolePattern = Pattern.compile("(.*)");
    }

    public Set<String> extractRoles(HttpServerRequest request) {
        return this.extractRoles(request.headers());
    }

    public Set<String> extractRoles(MultiMap headers) {
        HashSet<String> roles = null;
        String proxyGroupHeader = headers.get(groupHeader);
        String userRoles = null;
        userRoles = proxyGroupHeader != null ? proxyGroupHeader : headers.get(roleHeader);
        if (userRoles != null) {
            String[] split;
            roles = new HashSet<String>();
            for (String r : split = userRoles.split(",")) {
                r = r.trim();
                Matcher matcher = this.rolePattern.matcher(r = r.toLowerCase());
                if (!matcher.matches() || matcher.groupCount() <= 0) continue;
                roles.add(matcher.group(1));
            }
        }
        return roles;
    }
}

