/*
 * Decompiled with CFR 0.152.
 */
package org.swisspush.gateleen.core.event;

import io.vertx.core.MultiMap;
import io.vertx.core.eventbus.DeliveryOptions;
import io.vertx.core.eventbus.EventBus;
import io.vertx.core.eventbus.Message;
import io.vertx.core.json.JsonObject;
import java.io.IOException;
import java.io.Writer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EventBusWriter
extends Writer {
    private StringBuffer buffer;
    private EventBus eventBus;
    private String address;
    private MultiMap deliveryOptionsHeaders;
    private TransmissionMode transmissionMode;
    private Logger log = LoggerFactory.getLogger(EventBusWriter.class);

    public EventBusWriter(EventBus eventBus, String address, MultiMap deliveryOptionsHeaders, TransmissionMode transmissionMode) {
        this.eventBus = eventBus;
        this.address = address;
        this.deliveryOptionsHeaders = deliveryOptionsHeaders;
        this.transmissionMode = transmissionMode;
    }

    @Override
    public void write(char[] cbuf, int off, int len) throws IOException {
        if (this.buffer == null) {
            this.buffer = new StringBuffer();
        }
        this.buffer.append(cbuf, off, len);
    }

    @Override
    public void flush() throws IOException {
        if (this.buffer != null) {
            DeliveryOptions options = new DeliveryOptions();
            if (this.deliveryOptionsHeaders != null) {
                options.setHeaders(this.deliveryOptionsHeaders);
            }
            if (TransmissionMode.send == this.transmissionMode) {
                this.eventBus.request(this.address, (Object)this.buffer.toString(), options, reply -> {
                    if (reply.succeeded() && "ok".equals(((JsonObject)((Message)reply.result()).body()).getString("status"))) {
                        this.log.debug("Successfully sent to (and got reply from) eventBus address {}", (Object)this.address);
                    } else {
                        this.log.error("Failed to send (not publish) to the eventBus: {}", reply.cause());
                    }
                });
            } else {
                this.eventBus.publish(this.address, (Object)this.buffer.toString(), options);
            }
            this.buffer = null;
        }
    }

    @Override
    public void close() throws IOException {
        this.flush();
    }

    public static enum TransmissionMode {
        publish,
        send;


        public static TransmissionMode fromString(String mode) {
            for (TransmissionMode transmissionMode : TransmissionMode.values()) {
                if (!transmissionMode.name().equalsIgnoreCase(mode)) continue;
                return transmissionMode;
            }
            return publish;
        }
    }
}

