/*
 * Decompiled with CFR 0.152.
 */
package org.swisspush.gateleen.core.http;

import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.buffer.Buffer;
import java.util.LinkedList;
import java.util.Queue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BufferBridge {
    private Handler<Buffer> dataHandler;
    private Handler<Void> endHandler;
    private Handler<Buffer> bodyHandler;
    private Handler<Throwable> exceptionHandler;
    private Queue<Buffer> queue = new LinkedList<Buffer>();
    private Buffer body = Buffer.buffer();
    private boolean ended = false;
    private Vertx vertx;
    private final Logger log = LoggerFactory.getLogger(BufferBridge.class);

    public BufferBridge(Vertx vertx) {
        this.vertx = vertx;
    }

    protected void pump() {
        this.vertx.runOnContext(event -> {
            block5: {
                try {
                    if (!this.queue.isEmpty()) {
                        this.log.trace("Pumping from queue");
                        this.dataHandler.handle((Object)this.queue.poll());
                        this.pump();
                    } else if (this.ended && this.endHandler != null) {
                        this.log.trace("Ending from pump");
                        this.endHandler.handle(null);
                    }
                }
                catch (Exception e) {
                    if (this.exceptionHandler == null) break block5;
                    this.exceptionHandler.handle((Object)e);
                }
            }
        });
    }

    protected void doWrite(Buffer chunk) {
        this.body.appendBuffer(chunk);
        if (this.dataHandler != null && this.queue.isEmpty()) {
            this.log.trace("Writing directly to handler");
            try {
                this.dataHandler.handle((Object)chunk);
            }
            catch (Exception e) {
                if (this.exceptionHandler != null) {
                    this.exceptionHandler.handle((Object)e);
                }
            }
        } else {
            this.log.trace("Writing to queue");
            this.queue.offer(chunk);
        }
    }

    protected Future<Void> doEnd() {
        this.ended = true;
        if (this.bodyHandler != null) {
            this.bodyHandler.handle((Object)this.body);
        }
        if (this.endHandler != null && this.queue.isEmpty()) {
            block4: {
                this.log.trace("Ending handler directly");
                try {
                    this.endHandler.handle(null);
                }
                catch (Exception e) {
                    if (this.exceptionHandler == null) break block4;
                    this.exceptionHandler.handle((Object)e);
                }
            }
            this.endHandler = null;
            this.dataHandler = null;
        }
        return Future.succeededFuture();
    }

    public void setDataHandler(Handler<Buffer> dataHandler) {
        this.dataHandler = dataHandler;
    }

    public void setExceptionHandler(Handler<Throwable> exceptionHandler) {
        this.exceptionHandler = exceptionHandler;
    }

    public void setEndHandler(Handler<Void> endHandler) {
        this.endHandler = endHandler;
    }

    public void setBodyHandler(Handler<Buffer> bodyHandler) {
        this.bodyHandler = bodyHandler;
    }
}

