/*
 * Decompiled with CFR 0.152.
 */
package org.swisspush.gateleen.core.resource;

import io.vertx.core.MultiMap;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.HttpClient;
import io.vertx.core.http.HttpClientRequest;
import io.vertx.core.http.HttpClientResponse;
import io.vertx.core.http.HttpHeaders;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.http.HttpServerRequest;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.swisspush.gateleen.core.http.HeaderFunction;
import org.swisspush.gateleen.core.http.HeaderFunctions;
import org.swisspush.gateleen.core.http.RequestLoggerFactory;
import org.swisspush.gateleen.core.resource.CopyTask;
import org.swisspush.gateleen.core.util.HttpHeaderUtil;
import org.swisspush.gateleen.core.util.StatusCode;
import org.swisspush.gateleen.core.util.StatusCodeTranslator;

public class CopyResourceHandler {
    private static final Logger log = LoggerFactory.getLogger(CopyResourceHandler.class);
    private static final String SLASH = "/";
    private static final int DEFAULT_TIMEOUT = 120000;
    private final String copyPath;
    private final HttpClient selfClient;

    public CopyResourceHandler(HttpClient selfClient, String copyPath) {
        this.selfClient = selfClient;
        this.copyPath = copyPath;
    }

    public boolean handle(HttpServerRequest request) {
        Logger log = RequestLoggerFactory.getLogger(CopyResourceHandler.class, request);
        if (request.uri().equalsIgnoreCase(this.copyPath) && HttpMethod.POST == request.method()) {
            log.debug("handle -> {}", (Object)request.uri());
            request.bodyHandler(buffer -> {
                CopyTask task = this.createCopyTask(request, (Buffer)buffer);
                if (task != null && this.validTask(request, task)) {
                    this.performGETRequest(request, task);
                } else {
                    request.response().setStatusCode(StatusCode.BAD_REQUEST.getStatusCode());
                    request.response().setStatusMessage(StatusCode.BAD_REQUEST.getStatusMessage());
                    request.response().end();
                }
            });
            return true;
        }
        return false;
    }

    protected boolean validTask(HttpServerRequest request, CopyTask task) {
        if (task.getSourceUri().endsWith(SLASH) || task.getDestinationUri().endsWith(SLASH)) {
            Logger log = RequestLoggerFactory.getLogger(CopyResourceHandler.class, request);
            log.debug("invalid copy task, collections are not allowed!");
            return false;
        }
        return true;
    }

    protected void performGETRequest(HttpServerRequest request, CopyTask task) {
        this.selfClient.request(HttpMethod.GET, task.getSourceUri()).onComplete(event -> {
            if (event.failed()) {
                log.warn("Failed request to {}: {}", (Object)request.uri(), (Object)event.cause());
                return;
            }
            HttpClientRequest selfRequest = (HttpClientRequest)event.result();
            selfRequest.headers().setAll(task.getHeaders());
            selfRequest.setTimeout(120000L);
            selfRequest.exceptionHandler(exception -> log.warn("CopyResourceHandler: GET request failed: " + request.uri() + ": " + exception.getMessage()));
            selfRequest.send(asyncResult -> {
                HttpClientResponse response = (HttpClientResponse)asyncResult.result();
                if (response.statusCode() == StatusCode.OK.getStatusCode()) {
                    this.performPUTRequest(request, response, task);
                } else {
                    this.createResponse(request, response, task);
                }
            });
        });
    }

    protected void performPUTRequest(HttpServerRequest request, HttpClientResponse getResponse, CopyTask task) {
        getResponse.bodyHandler(data -> {
            if (getResponse.statusCode() == StatusCode.OK.getStatusCode()) {
                this.selfClient.request(HttpMethod.PUT, task.getDestinationUri()).onComplete(event -> {
                    if (event.failed()) {
                        log.warn("Failed request to {}: {}", (Object)request.uri(), (Object)event.cause());
                        return;
                    }
                    HttpClientRequest selfRequest = (HttpClientRequest)event.result();
                    HttpHeaderUtil.mergeHeaders(selfRequest.headers(), task.getHeaders(), task.getDestinationUri());
                    selfRequest.write(data);
                    selfRequest.setTimeout(120000L);
                    selfRequest.send(asyncResult -> {
                        HttpClientResponse response = (HttpClientResponse)asyncResult.result();
                        this.createResponse(request, response, task);
                    });
                });
            } else {
                this.createResponse(request, getResponse, task);
            }
        });
    }

    private void createResponse(HttpServerRequest request, HttpClientResponse response, CopyTask task) {
        Logger log = RequestLoggerFactory.getLogger(CopyResourceHandler.class, request);
        if (response.statusCode() == StatusCode.OK.getStatusCode()) {
            log.debug("copy resource task successfully executed: {} -> {}", (Object)task.getSourceUri(), (Object)task.getDestinationUri());
        } else {
            log.debug("copy resource task failed: {} -> {}", (Object)task.getSourceUri(), (Object)task.getDestinationUri());
        }
        request.response().setStatusCode(StatusCodeTranslator.translateStatusCode(response.statusCode(), request.headers()));
        request.response().setStatusMessage(response.statusMessage());
        response.bodyHandler(buffer -> {
            request.response().putHeader(HttpHeaders.CONTENT_LENGTH, (CharSequence)String.valueOf(buffer.length()));
            request.response().end(buffer);
        });
    }

    CopyTask createCopyTask(HttpServerRequest request, Buffer buffer) {
        JsonObject task = new JsonObject(buffer.toString());
        HeaderFunction headerFunction = HeaderFunctions.DO_NOTHING;
        JsonObject staticHeaders = task.getJsonObject("staticHeaders");
        if (staticHeaders != null) {
            headerFunction = HeaderFunctions.parseStaticHeadersFromJson(staticHeaders);
        } else {
            JsonArray dynamicHeaders = task.getJsonArray("headers");
            if (dynamicHeaders != null) {
                headerFunction = HeaderFunctions.parseFromJson(dynamicHeaders);
            }
        }
        MultiMap headers = StatusCodeTranslator.getTranslateFreeHeaders(request.headers());
        HeaderFunctions.EvalScope evalScope = headerFunction.apply(headers);
        if (evalScope.getErrorMessage() != null) {
            log.warn("Problem invoking Header functions: {}", (Object)evalScope.getErrorMessage());
            return null;
        }
        HttpHeaderUtil.removeNonForwardHeaders(headers);
        headers.remove("content-length");
        return new CopyTask(task.getString("source"), task.getString("destination"), headers);
    }
}

