/*
 * Decompiled with CFR 0.152.
 */
package org.swisspush.gateleen.core.lock.impl;

import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Promise;
import io.vertx.core.json.JsonArray;
import io.vertx.redis.client.Command;
import io.vertx.redis.client.RedisAPI;
import io.vertx.redis.client.Response;
import java.util.Collections;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.swisspush.gateleen.core.lock.Lock;
import org.swisspush.gateleen.core.lock.lua.LockLuaScripts;
import org.swisspush.gateleen.core.lock.lua.ReleaseLockRedisCommand;
import org.swisspush.gateleen.core.lua.LuaScriptState;
import org.swisspush.gateleen.core.util.RedisUtils;

public class RedisBasedLock
implements Lock {
    private Logger log = LoggerFactory.getLogger(RedisBasedLock.class);
    public static final String STORAGE_PREFIX = "gateleen.core-lock:";
    private LuaScriptState releaseLockLuaScriptState;
    private RedisAPI redisAPI;

    public RedisBasedLock(RedisAPI redisAPI) {
        this.redisAPI = redisAPI;
        this.releaseLockLuaScriptState = new LuaScriptState(LockLuaScripts.LOCK_RELEASE, redisAPI, false);
    }

    private void redisSetWithOptions(String key, String value, boolean nx, long px, Handler<AsyncResult<Response>> handler) {
        JsonArray options = new JsonArray();
        options.add((Object)"PX").add((Object)px);
        if (nx) {
            options.add((Object)"NX");
        }
        this.redisAPI.send(Command.SET, RedisUtils.toPayload(key, value, options).toArray(new String[0])).onComplete(handler);
    }

    @Override
    public Future<Boolean> acquireLock(String lock, String token, long lockExpiryMs) {
        Promise promise = Promise.promise();
        this.redisSetWithOptions(this.buildLockKey(lock), token, true, lockExpiryMs, (Handler<AsyncResult<Response>>)((Handler)event -> {
            if (event.succeeded()) {
                if (event.result() != null) {
                    promise.complete((Object)"OK".equalsIgnoreCase(((Response)event.result()).toString()));
                } else {
                    promise.complete((Object)false);
                }
            } else {
                promise.fail(event.cause().getMessage());
            }
        }));
        return promise.future();
    }

    @Override
    public Future<Boolean> releaseLock(String lock, String token) {
        Promise promise = Promise.promise();
        List<String> keys = Collections.singletonList(this.buildLockKey(lock));
        List<String> arguments = Collections.singletonList(token);
        ReleaseLockRedisCommand cmd = new ReleaseLockRedisCommand(this.releaseLockLuaScriptState, keys, arguments, this.redisAPI, this.log, (Promise<Boolean>)promise);
        cmd.exec(0);
        return promise.future();
    }

    private String buildLockKey(String lock) {
        return STORAGE_PREFIX + lock;
    }
}

