/*
 * Decompiled with CFR 0.152.
 */
package org.swisspush.gateleen.core.lock.lua;

import io.vertx.core.Promise;
import io.vertx.redis.client.RedisAPI;
import io.vertx.redis.client.Response;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.swisspush.gateleen.core.lua.LuaScriptState;
import org.swisspush.gateleen.core.lua.RedisCommand;

public class ReleaseLockRedisCommand
implements RedisCommand {
    private LuaScriptState luaScriptState;
    private List<String> keys;
    private List<String> arguments;
    private Promise<Boolean> promise;
    private RedisAPI redisAPI;
    private Logger log;

    public ReleaseLockRedisCommand(LuaScriptState luaScriptState, List<String> keys, List<String> arguments, RedisAPI redisAPI, Logger log, Promise<Boolean> promise) {
        this.luaScriptState = luaScriptState;
        this.keys = keys;
        this.arguments = arguments;
        this.redisAPI = redisAPI;
        this.log = log;
        this.promise = promise;
    }

    @Override
    public void exec(int executionCounter) {
        ArrayList<String> args = new ArrayList<String>();
        args.add(this.luaScriptState.getSha());
        args.add(String.valueOf(this.keys.size()));
        args.addAll(this.keys);
        args.addAll(this.arguments);
        this.redisAPI.evalsha(args, event -> {
            if (event.succeeded()) {
                Long unlocked = ((Response)event.result()).toLong();
                this.promise.complete((Object)(unlocked > 0L ? 1 : 0));
            } else {
                String message = event.cause().getMessage();
                if (message != null && message.startsWith("NOSCRIPT")) {
                    this.log.warn("ReleaseLockRedisCommand script couldn't be found, reload it");
                    this.log.warn("amount the script got loaded: " + executionCounter);
                    if (executionCounter > 10) {
                        this.promise.fail("amount the script got loaded is higher than 10, we abort");
                    } else {
                        this.luaScriptState.loadLuaScript(new ReleaseLockRedisCommand(this.luaScriptState, this.keys, this.arguments, this.redisAPI, this.log, this.promise), executionCounter);
                    }
                } else {
                    this.promise.fail("ReleaseLockRedisCommand request failed with message: " + message);
                }
            }
        });
    }
}

