/*
 * Decompiled with CFR 0.152.
 */
package org.swisspush.gateleen.core.storage;

import io.vertx.core.Handler;
import io.vertx.core.MultiMap;
import io.vertx.core.Vertx;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.HttpClient;
import io.vertx.core.http.HttpClientOptions;
import io.vertx.core.http.HttpClientRequest;
import io.vertx.core.http.HttpClientResponse;
import io.vertx.core.http.HttpMethod;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.swisspush.gateleen.core.storage.ResourceStorage;
import org.swisspush.gateleen.core.util.HttpHeaderUtil;
import org.swisspush.gateleen.core.util.StatusCode;

public class HttpResourceStorage
implements ResourceStorage {
    private String host;
    private int port;
    private HttpClient client;
    private Logger log = LoggerFactory.getLogger(HttpResourceStorage.class);
    private static final long TIMEOUT = 30000L;

    public HttpResourceStorage(Vertx vertx) {
        this(vertx, "localhost", 8989);
    }

    public HttpResourceStorage(Vertx vertx, String host, int port) {
        this.host = host;
        this.port = port;
        this.client = vertx.createHttpClient(new HttpClientOptions().setDefaultHost(host).setDefaultPort(port).setMaxPoolSize(500).setReuseAddress(true).setKeepAlive(true).setPipelining(false));
    }

    @Override
    public void get(String path, Handler<Buffer> bodyHandler) {
        this.log.debug("Reading {}", (Object)path);
        this.client.request(HttpMethod.GET, path).onComplete(asyncResult -> {
            if (asyncResult.failed()) {
                this.log.warn("Failed request to {}: {}", (Object)path, (Object)asyncResult.cause());
                return;
            }
            HttpClientRequest request = (HttpClientRequest)asyncResult.result();
            request.exceptionHandler(e -> {
                this.log.error("Storage request error", e);
                bodyHandler.handle(null);
            });
            request.setTimeout(30000L);
            request.send(event -> {
                HttpClientResponse response = (HttpClientResponse)event.result();
                response.exceptionHandler(exception -> {
                    this.log.error("Reading {} failed: {}", (Object)path, (Object)exception.getMessage());
                    bodyHandler.handle(null);
                });
                if (response.statusCode() == StatusCode.OK.getStatusCode()) {
                    response.bodyHandler(bodyHandler);
                } else {
                    this.log.debug("Got status code other than 200. Status code = {}, status message is '{}'.", response == null ? "<null>" : Integer.valueOf(response.statusCode()), (Object)(response == null || response.statusMessage() == null ? "<null>" : response.statusMessage()));
                    bodyHandler.handle(null);
                }
            });
        });
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    @Override
    public void put(String uri, MultiMap headers, Buffer buffer, Handler<Integer> doneHandler) {
        this.client.request(HttpMethod.PUT, uri).onComplete(asyncResult -> {
            if (asyncResult.failed()) {
                this.log.warn("Failed request to {}: {}", (Object)uri, (Object)asyncResult.cause());
                return;
            }
            HttpClientRequest request = (HttpClientRequest)asyncResult.result();
            request.exceptionHandler(exception -> {
                this.log.error("Putting {} failed: {}", (Object)uri, (Object)exception.getMessage());
                doneHandler.handle((Object)StatusCode.INTERNAL_SERVER_ERROR.getStatusCode());
            });
            if (headers != null) {
                HttpHeaderUtil.mergeHeaders(request.headers(), headers, uri);
            }
            request.setTimeout(30000L);
            request.putHeader("Content-Length", "" + buffer.length());
            request.write((Object)buffer);
            request.send(asyncRespnose -> {
                HttpClientResponse response = (HttpClientResponse)asyncRespnose.result();
                response.exceptionHandler(exception -> {
                    this.log.error("Exception on response to PUT from {}: {}", (Object)uri, (Object)exception.getMessage());
                    doneHandler.handle((Object)StatusCode.INTERNAL_SERVER_ERROR.getStatusCode());
                });
                response.endHandler(event -> doneHandler.handle((Object)response.statusCode()));
            });
        });
    }

    @Override
    public void put(String uri, Buffer buffer, Handler<Integer> doneHandler) {
        this.put(uri, null, buffer, doneHandler);
    }

    @Override
    public void delete(String uri, Handler<Integer> doneHandler) {
        this.client.request(HttpMethod.DELETE, uri).onComplete(asyncResult -> {
            if (asyncResult.failed()) {
                this.log.warn("Failed request to {}: {}", (Object)uri, (Object)asyncResult.cause());
                return;
            }
            HttpClientRequest request = (HttpClientRequest)asyncResult.result();
            request.exceptionHandler(exception -> {
                this.log.error("Deleting {} failed: {}", (Object)uri, (Object)exception.getMessage());
                doneHandler.handle((Object)StatusCode.INTERNAL_SERVER_ERROR.getStatusCode());
            });
            request.setTimeout(30000L);
            request.send(asyncRespnose -> {
                HttpClientResponse response = (HttpClientResponse)asyncRespnose.result();
                response.exceptionHandler(exception -> {
                    this.log.error("Exception on response to DELETE from {}: {}", (Object)uri, (Object)exception.getMessage());
                    doneHandler.handle((Object)StatusCode.INTERNAL_SERVER_ERROR.getStatusCode());
                });
                response.endHandler(event -> doneHandler.handle((Object)response.statusCode()));
            });
        });
    }
}

