/*
 * Decompiled with CFR 0.152.
 */
package org.swisspush.gateleen.core.http;

import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.MultiMap;
import io.vertx.core.Promise;
import io.vertx.core.http.HttpClient;
import io.vertx.core.http.HttpClientRequest;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.http.impl.headers.HeadersMultiMap;

public class ClientRequestCreator {
    private final HttpClient selfClient;

    public ClientRequestCreator(HttpClient selfClient) {
        this.selfClient = selfClient;
    }

    public Future<HttpClientRequest> createClientRequest(HttpMethod method, String requestURI, HeadersMultiMap headers, long timeoutMs, Handler<Throwable> exceptionHandler) {
        Promise promise = Promise.promise();
        this.selfClient.request(method, requestURI).onComplete(asyncResult -> {
            HttpClientRequest delegateRequest = (HttpClientRequest)asyncResult.result();
            if (asyncResult.failed()) {
                promise.fail(asyncResult.cause());
                return;
            }
            delegateRequest.headers().setAll((MultiMap)headers);
            delegateRequest.exceptionHandler(exceptionHandler);
            delegateRequest.idleTimeout(timeoutMs);
            promise.complete((Object)delegateRequest);
        });
        return promise.future();
    }
}

