/*
 * Decompiled with CFR 0.152.
 */
package org.swisspush.gateleen.core.http;

import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.MultiMap;
import io.vertx.core.Promise;
import io.vertx.core.Vertx;
import io.vertx.core.http.HttpClient;
import io.vertx.core.http.HttpClientRequest;
import io.vertx.core.http.HttpClientResponse;
import io.vertx.core.http.HttpConnection;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.http.RequestOptions;
import io.vertx.core.http.WebSocket;
import io.vertx.core.http.WebSocketConnectOptions;
import io.vertx.core.http.WebsocketVersion;
import io.vertx.core.net.SSLOptions;
import java.util.List;
import java.util.function.Function;

public abstract class AbstractHttpClient
implements HttpClient {
    private final Vertx vertx;

    public AbstractHttpClient(Vertx vertx) {
        this.vertx = vertx;
    }

    protected abstract HttpClientRequest doRequest(HttpMethod var1, String var2);

    public HttpClientRequest options(String uri) {
        return this.doRequest(HttpMethod.OPTIONS, uri);
    }

    public HttpClientRequest get(String uri) {
        return this.doRequest(HttpMethod.GET, uri);
    }

    public HttpClientRequest head(String uri) {
        return this.doRequest(HttpMethod.HEAD, uri);
    }

    public HttpClientRequest post(String uri) {
        return this.doRequest(HttpMethod.POST, uri);
    }

    public HttpClient connectionHandler(Handler<HttpConnection> handler) {
        throw new UnsupportedOperationException();
    }

    public HttpClient redirectHandler(Function<HttpClientResponse, Future<RequestOptions>> function) {
        throw new UnsupportedOperationException();
    }

    public Function<HttpClientResponse, Future<RequestOptions>> redirectHandler() {
        throw new UnsupportedOperationException();
    }

    public void close(Handler<AsyncResult<Void>> handler) {
        this.close().onComplete(handler);
    }

    public Future<Void> close() {
        Promise promise = Promise.promise();
        this.vertx.runOnContext(v -> promise.complete());
        return promise.future();
    }

    public void request(RequestOptions requestOptions, Handler<AsyncResult<HttpClientRequest>> handler) {
        throw new UnsupportedOperationException();
    }

    public Future<HttpClientRequest> request(RequestOptions requestOptions) {
        throw new UnsupportedOperationException();
    }

    public void request(HttpMethod httpMethod, int i, String s, String s1, Handler<AsyncResult<HttpClientRequest>> handler) {
        this.vertx.runOnContext(v -> Future.succeededFuture((Object)this.doRequest(httpMethod, s1)).onComplete(handler));
    }

    public Future<HttpClientRequest> request(HttpMethod httpMethod, int i, String s, String s1) {
        return Future.succeededFuture((Object)this.doRequest(HttpMethod.GET, s1));
    }

    public void request(HttpMethod httpMethod, String s, String s1, Handler<AsyncResult<HttpClientRequest>> handler) {
        throw new UnsupportedOperationException();
    }

    public Future<HttpClientRequest> request(HttpMethod httpMethod, String s, String s1) {
        throw new UnsupportedOperationException();
    }

    public void request(HttpMethod method, String requestURI, Handler<AsyncResult<HttpClientRequest>> handler) {
        this.vertx.runOnContext(v -> Future.succeededFuture((Object)this.doRequest(method, requestURI)).onComplete(handler));
    }

    public Future<HttpClientRequest> request(HttpMethod httpMethod, String requestURI) {
        return Future.succeededFuture((Object)this.doRequest(httpMethod, requestURI));
    }

    public void webSocket(int i, String s, String s1, Handler<AsyncResult<WebSocket>> handler) {
        throw new UnsupportedOperationException();
    }

    public Future<WebSocket> webSocket(int i, String s, String s1) {
        throw new UnsupportedOperationException();
    }

    public void webSocket(String s, String s1, Handler<AsyncResult<WebSocket>> handler) {
        throw new UnsupportedOperationException();
    }

    public Future<WebSocket> webSocket(String s, String s1) {
        throw new UnsupportedOperationException();
    }

    public void webSocket(String s, Handler<AsyncResult<WebSocket>> handler) {
        throw new UnsupportedOperationException();
    }

    public Future<WebSocket> webSocket(String s) {
        throw new UnsupportedOperationException();
    }

    public void webSocket(WebSocketConnectOptions webSocketConnectOptions, Handler<AsyncResult<WebSocket>> handler) {
        throw new UnsupportedOperationException();
    }

    public Future<WebSocket> webSocket(WebSocketConnectOptions webSocketConnectOptions) {
        throw new UnsupportedOperationException();
    }

    public void webSocketAbs(String s, MultiMap multiMap, WebsocketVersion websocketVersion, List<String> list, Handler<AsyncResult<WebSocket>> handler) {
        throw new UnsupportedOperationException();
    }

    public Future<WebSocket> webSocketAbs(String s, MultiMap multiMap, WebsocketVersion websocketVersion, List<String> list) {
        throw new UnsupportedOperationException();
    }

    public boolean isMetricsEnabled() {
        throw new UnsupportedOperationException();
    }

    public Future<Boolean> updateSSLOptions(SSLOptions options, boolean force) {
        throw new UnsupportedOperationException();
    }
}

