/*
 * Decompiled with CFR 0.152.
 */
package org.swisspush.gateleen.core.util;

import io.vertx.core.MultiMap;

public enum HttpRequestHeader {
    CONNECTION("connection"),
    CONTENT_LENGTH("Content-Length"),
    X_HOPS("x-hops");

    private final String name;

    private HttpRequestHeader(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public static boolean containsHeader(MultiMap headers, HttpRequestHeader httpRequestHeader) {
        if (headers == null) {
            return false;
        }
        return headers.contains(httpRequestHeader.getName());
    }

    public static Integer getInteger(MultiMap headers, HttpRequestHeader httpRequestHeader) {
        return HttpRequestHeader.getInteger(headers, httpRequestHeader, null);
    }

    public static Integer getInteger(MultiMap headers, HttpRequestHeader httpRequestHeader, Integer defaultValue) {
        String headerValue = null;
        if (headers != null) {
            headerValue = headers.get(httpRequestHeader.getName());
        }
        try {
            return Integer.parseInt(headerValue);
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    public static String getString(MultiMap headers, HttpRequestHeader httpRequestHeader) {
        if (headers == null) {
            return null;
        }
        return headers.get(httpRequestHeader.getName());
    }
}

