/*
 * Decompiled with CFR 0.152.
 */
package org.swisspush.gateleen.core.http;

import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.MultiMap;
import io.vertx.core.Vertx;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.HttpClientRequest;
import io.vertx.core.http.HttpClientResponse;
import io.vertx.core.http.HttpFrame;
import io.vertx.core.http.HttpHeaders;
import io.vertx.core.http.HttpServerResponse;
import io.vertx.core.http.impl.headers.HeadersMultiMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.swisspush.gateleen.core.exception.GateleenExceptionFactory;
import org.swisspush.gateleen.core.http.BufferBridge;
import org.swisspush.gateleen.core.http.FastFaiHttpClientResponse;
import org.swisspush.gateleen.core.http.FastFailHttpServerResponse;
import org.swisspush.gateleen.core.util.StatusCode;

public class LocalHttpServerResponse
extends BufferBridge
implements FastFailHttpServerResponse {
    private static final Logger logger = LoggerFactory.getLogger(LocalHttpServerResponse.class);
    private final GateleenExceptionFactory exceptionFactory;
    private int statusCode;
    private String statusMessage;
    private static final String EMPTY = "";
    private MultiMap headers = new HeadersMultiMap();
    private boolean chunked = false;
    private boolean bound = false;
    private boolean closed = false;
    private boolean written = false;
    private Handler<AsyncResult<HttpClientResponse>> responseHandler;
    public HttpClientResponse clientResponse = new FastFaiHttpClientResponse(){

        @Override
        public int statusCode() {
            return LocalHttpServerResponse.this.statusCode;
        }

        @Override
        public String statusMessage() {
            if (LocalHttpServerResponse.this.statusMessage == null) {
                StatusCode code = StatusCode.fromCode(this.statusCode());
                LocalHttpServerResponse.this.statusMessage = code != null ? code.getStatusMessage() : LocalHttpServerResponse.EMPTY;
            }
            return LocalHttpServerResponse.this.statusMessage;
        }

        @Override
        public MultiMap headers() {
            return LocalHttpServerResponse.this.headers;
        }

        @Override
        public String getHeader(String headerName) {
            return this.headers().get(headerName);
        }

        @Override
        public String getHeader(CharSequence headerName) {
            return this.headers().get(headerName);
        }

        @Override
        public HttpClientResponse bodyHandler(Handler<Buffer> bodyHandler) {
            Buffer body = Buffer.buffer();
            this.handler((Handler<Buffer>)((Handler)arg_0 -> ((Buffer)body).appendBuffer(arg_0)));
            this.endHandler((Handler<Void>)((Handler)aVoid -> bodyHandler.handle((Object)body)));
            return this;
        }

        public Future<Buffer> body() {
            throw new UnsupportedOperationException();
        }

        public Future<Void> end() {
            throw new UnsupportedOperationException();
        }

        @Override
        public HttpClientResponse customFrameHandler(Handler<HttpFrame> handler) {
            return this;
        }

        @Override
        public HttpClientRequest request() {
            throw new UnsupportedOperationException();
        }

        @Override
        public HttpClientResponse endHandler(Handler<Void> handler) {
            LocalHttpServerResponse.this.setEndHandler(handler);
            return this;
        }

        @Override
        public HttpClientResponse handler(Handler<Buffer> handler) {
            LocalHttpServerResponse.this.setDataHandler(handler);
            LocalHttpServerResponse.this.pump();
            return this;
        }

        @Override
        public HttpClientResponse pause() {
            return this;
        }

        @Override
        public HttpClientResponse resume() {
            return this;
        }

        @Override
        public HttpClientResponse exceptionHandler(Handler<Throwable> handler) {
            return this;
        }
    };

    public LocalHttpServerResponse(Vertx vertx, GateleenExceptionFactory exceptionFactory) {
        super(vertx);
        this.exceptionFactory = exceptionFactory;
        this.setExceptionHandler((Handler<Throwable>)((Handler)thr -> logger.error("Processing of response failed.", thr)));
    }

    @Override
    public int getStatusCode() {
        return this.statusCode;
    }

    @Override
    public HttpServerResponse setStatusCode(int statusCode) {
        this.statusCode = statusCode;
        return this;
    }

    @Override
    public String getStatusMessage() {
        if (this.statusMessage == null) {
            StatusCode code = StatusCode.fromCode(this.getStatusCode());
            this.statusMessage = code != null ? code.getStatusMessage() : EMPTY;
        }
        return this.statusMessage;
    }

    @Override
    public HttpServerResponse setStatusMessage(String statusMessage) {
        this.statusMessage = statusMessage;
        return this;
    }

    @Override
    public HttpServerResponse setChunked(boolean chunked) {
        this.chunked = chunked;
        return this;
    }

    @Override
    public boolean isChunked() {
        return this.chunked;
    }

    @Override
    public MultiMap headers() {
        return this.headers;
    }

    @Override
    public HttpServerResponse putHeader(String name, String value) {
        this.headers().set(name, value);
        return this;
    }

    @Override
    public HttpServerResponse putHeader(CharSequence name, CharSequence value) {
        this.headers().set(name, value);
        return this;
    }

    @Override
    public HttpServerResponse putHeader(String name, Iterable<String> values) {
        for (String value : values) {
            this.headers().add(name, value);
        }
        return this;
    }

    @Override
    public HttpServerResponse putHeader(CharSequence name, Iterable<CharSequence> values) {
        for (CharSequence value : values) {
            this.headers().add(name, value);
        }
        return this;
    }

    @Override
    public HttpServerResponse closeHandler(Handler<Void> handler) {
        return this;
    }

    @Override
    public Future<Void> write(String chunk, String enc) {
        return this.write(Buffer.buffer((String)chunk, (String)enc));
    }

    @Override
    public Future<Void> write(Buffer data) {
        if (!this.chunked && !this.headers.contains(HttpHeaders.CONTENT_LENGTH)) {
            IllegalStateException ex = this.exceptionFactory.newIllegalStateException("You must set the Content-Length header to be the total size of the message body BEFORE sending any data if you are not using HTTP chunked encoding.");
            logger.debug("non-proper HttpServerResponse occurred", (Throwable)ex);
            throw ex;
        }
        this.ensureBound();
        this.doWrite(data);
        return Future.succeededFuture();
    }

    @Override
    public void write(Buffer data, Handler<AsyncResult<Void>> handler) {
        this.write(data).onComplete(handler);
    }

    @Override
    public void write(String chunk, String enc, Handler<AsyncResult<Void>> handler) {
        this.write(chunk, enc).onComplete(handler);
    }

    @Override
    public Future<Void> write(String chunk) {
        return this.write(Buffer.buffer((String)chunk));
    }

    @Override
    public void write(String chunk, Handler<AsyncResult<Void>> handler) {
        this.write(chunk).onComplete(handler);
    }

    private void ensureBound() {
        if (!this.bound) {
            this.bound = true;
            if (this.statusCode == 0) {
                this.statusCode = 200;
                this.statusMessage = "OK";
            }
            if (this.chunked) {
                this.headers.set(HttpHeaders.TRANSFER_ENCODING, HttpHeaders.CHUNKED);
            }
            this.responseHandler.handle((Object)Future.succeededFuture((Object)this.clientResponse));
        }
    }

    public Future<Void> end(String chunk) {
        return this.end(Buffer.buffer((String)chunk));
    }

    @Override
    public Future<Void> end(String chunk, String enc) {
        return this.end(Buffer.buffer((String)chunk, (String)enc));
    }

    public Future<Void> end(Buffer chunk) {
        if (!(this.bound || this.chunked || this.headers.contains(HttpHeaders.CONTENT_LENGTH))) {
            this.headers.set(HttpHeaders.CONTENT_LENGTH, (CharSequence)String.valueOf(chunk.length()));
        }
        this.write(chunk);
        return this.end();
    }

    public Future<Void> end() {
        this.written = true;
        this.ensureBound();
        return this.doEnd();
    }

    @Override
    public void close() {
        this.closed = true;
    }

    @Override
    public boolean ended() {
        return this.written;
    }

    @Override
    public boolean closed() {
        return this.closed;
    }

    @Override
    public boolean headWritten() {
        return this.written;
    }

    @Override
    public HttpServerResponse setWriteQueueMaxSize(int maxSize) {
        return this;
    }

    @Override
    public boolean writeQueueFull() {
        return false;
    }

    @Override
    public HttpServerResponse exceptionHandler(Handler<Throwable> handler) {
        this.setExceptionHandler(handler);
        return this;
    }

    public void setHttpClientResponseHandler(Handler<AsyncResult<HttpClientResponse>> responseHandler) {
        this.responseHandler = responseHandler;
    }
}

