/*
 * Decompiled with CFR 0.152.
 */
package org.swisspush.gateleen.core.util;

import com.google.common.base.Charsets;
import com.google.common.io.Resources;
import java.net.URL;
import java.nio.charset.Charset;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResourcesUtils {
    private static Logger log = LoggerFactory.getLogger(ResourcesUtils.class);

    private ResourcesUtils() {
    }

    public static String loadResource(String resourceName, boolean exceptionWhenNotFound) {
        try {
            URL url = Resources.getResource((String)resourceName);
            return Resources.toString((URL)url, (Charset)Charsets.UTF_8);
        }
        catch (Exception e) {
            log.error("Error loading resource '" + resourceName + "'", (Throwable)e);
            if (exceptionWhenNotFound) {
                throw new RuntimeException("Error loading required resource '" + resourceName + "'");
            }
            return null;
        }
    }
}

